/*
 * Decompiled with CFR 0.152.
 */
package eu.lp0.slf4j.android;

import eu.lp0.slf4j.android.LogAdapter;
import eu.lp0.slf4j.android.LoggerConfig;
import eu.lp0.slf4j.android.LoggingConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public final class LoggerFactory
implements ILoggerFactory {
    private static final Logger LOG;
    private static final boolean TRACE;
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    private final LoggingConfig loggingConfig = new LoggingConfig("config.properties", LOG);
    static final int MAX_TAG_LEN = 23;

    public final Logger getLogger(String name) {
        long start = TRACE ? System.nanoTime() : 0L;
        Logger logger = (Logger)this.loggerMap.get(name);
        if (logger != null) {
            if (TRACE) {
                long stop = System.nanoTime();
                LOG.trace("Found logger {} in {}\u00b5s", (Object)name, (Object)TimeUnit.NANOSECONDS.toMicros(stop - start));
            }
            return logger;
        }
        LogAdapter newInstance = new LogAdapter(name, this.getConfig(name));
        Logger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        if (TRACE) {
            long stop = System.nanoTime();
            if (oldInstance == null) {
                LOG.trace("Created logger {} in {}\u00b5s", (Object)name, (Object)TimeUnit.NANOSECONDS.toMicros(stop - start));
            } else {
                LOG.trace("Found existing logger {} in {}\u00b5s", (Object)name, (Object)TimeUnit.NANOSECONDS.toMicros(stop - start));
            }
        }
        return oldInstance == null ? newInstance : oldInstance;
    }

    static final String createTag(String name) {
        if (name.length() <= 23) {
            return name;
        }
        char[] tag = name.toCharArray();
        int arrayLen = tag.length;
        int len = 0;
        int mark = 0;
        int i = 0;
        while (i < arrayLen) {
            if (tag[i] == '.') {
                len = mark;
                if (tag[len] != '.') {
                    // empty if block
                }
                mark = ++len;
                if (i + 1 < arrayLen && tag[i + 1] != '.') {
                    ++mark;
                }
            }
            tag[len] = tag[i];
            ++i;
            ++len;
        }
        if (len > 23) {
            i = 0;
            --mark;
            for (int j = 0; j < len; ++j) {
                if (tag[j] == '.' && (j != mark || i >= 22)) continue;
                tag[i++] = tag[j];
            }
            len = i;
            if (len > 23) {
                len = 23;
            }
        }
        return new String(tag, 0, len);
    }

    private final LoggerConfig getConfig(String name) {
        long start = TRACE ? System.nanoTime() : 0L;
        LoggerConfig config = this.loggingConfig.get(name);
        if (config.tag.length() == 0) {
            config.tag = LoggerFactory.createTag(name);
            if (TRACE) {
                LOG.trace("Created tag {} for {}", (Object)config.tag, (Object)name);
            }
        }
        if (TRACE) {
            long stop = System.nanoTime();
            LOG.trace("Retrieved config for {} in {}\u00b5s", (Object)name, (Object)TimeUnit.NANOSECONDS.toMicros(stop - start));
        }
        return config;
    }

    static {
        LoggerConfig config = new LoggerConfig("slf4j-android");
        config.showThread = true;
        config.merge(LoggerConfig.DEFAULT);
        LOG = new LogAdapter("eu.lp0.slf4j.android", config);
        TRACE = LOG.isTraceEnabled();
    }
}

