/*
 * Decompiled with CFR 0.152.
 */
package org.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.DomTripException;
import eu.maveniverse.domtrip.Editor;
import eu.maveniverse.domtrip.Element;
import java.util.List;

public abstract class AbstractMavenEditor
extends Editor {
    protected AbstractMavenEditor() {
    }

    protected AbstractMavenEditor(DomTripConfig config) {
        super(config);
    }

    protected AbstractMavenEditor(Document document) {
        super(document);
    }

    protected AbstractMavenEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    protected abstract List<String> getOrderListForParent(Element var1);

    protected Element insertElementAtCorrectPosition(Element parent, String elementName, String textContent) throws DomTripException {
        List<String> order = this.getOrderListForParent(parent);
        return this.insertElementAtCorrectPosition(parent, elementName, textContent, order);
    }

    protected Element insertElementAtCorrectPosition(Element parent, String elementName, String textContent, List<String> order) throws DomTripException {
        Element existing;
        int i;
        if (order == null) {
            Element element = this.addElement(parent, elementName);
            if (textContent != null && !textContent.isEmpty()) {
                element.textContent(textContent);
            }
            return element;
        }
        int newElementIndex = order.indexOf(elementName);
        if (newElementIndex == -1) {
            Element element = this.addElement(parent, elementName);
            if (textContent != null && !textContent.isEmpty()) {
                element.textContent(textContent);
            }
            return element;
        }
        Element insertAfter = null;
        Element insertBefore = null;
        for (i = newElementIndex - 1; i >= 0; --i) {
            String beforeElementName = order.get(i);
            if (this.shouldSkipInOrdering(beforeElementName) || (existing = (Element)parent.child(beforeElementName).orElse(null)) == null) continue;
            insertAfter = existing;
            break;
        }
        for (i = newElementIndex + 1; i < order.size(); ++i) {
            String afterElementName = order.get(i);
            if (this.shouldSkipInOrdering(afterElementName) || (existing = (Element)parent.child(afterElementName).orElse(null)) == null) continue;
            insertBefore = existing;
            break;
        }
        Element element = this.insertElementAtPosition(parent, elementName, insertBefore, insertAfter, order, newElementIndex);
        if (textContent != null && !textContent.isEmpty()) {
            element.textContent(textContent);
        }
        return element;
    }

    protected boolean shouldSkipInOrdering(String elementName) {
        return false;
    }

    protected Element insertElementAtPosition(Element parent, String elementName, Element insertBefore, Element insertAfter, List<String> order, int elementIndex) throws DomTripException {
        if (insertBefore != null) {
            return this.insertElementBefore(insertBefore, elementName);
        }
        if (insertAfter != null) {
            return this.insertElementAfter(insertAfter, elementName);
        }
        return this.addElement(parent, elementName);
    }
}

