/*
 * Decompiled with CFR 0.152.
 */
package org.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.maveniverse.domtrip.maven.AbstractMavenEditor;

public class ExtensionsEditor
extends AbstractMavenEditor {
    private static final List<String> EXTENSION_ELEMENT_ORDER = Arrays.asList("groupId", "artifactId", "version", "classifier", "type", "configuration");

    public ExtensionsEditor() {
    }

    public ExtensionsEditor(DomTripConfig config) {
        super(config);
    }

    public ExtensionsEditor(Document document) {
        super(document);
    }

    public ExtensionsEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    public void createExtensionsDocument() {
        this.createDocument("extensions");
        Element root = this.root();
        root.attribute("xmlns", "http://maven.apache.org/EXTENSIONS/1.2.0");
        root.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.attribute("xsi:schemaLocation", "http://maven.apache.org/EXTENSIONS/1.2.0 https://maven.apache.org/xsd/core-extensions-1.2.0.xsd");
    }

    public Element insertExtensionsElement(Element parent, String elementName) {
        return this.insertExtensionsElement(parent, elementName, null);
    }

    public Element insertExtensionsElement(Element parent, String elementName, String textContent) {
        return this.insertElementAtCorrectPosition(parent, elementName, textContent);
    }

    public Element addExtension(Element extensionsElement, String groupId, String artifactId, String version) {
        return this.addExtension(extensionsElement, groupId, artifactId, version, null, null);
    }

    public Element addExtension(Element extensionsElement, String groupId, String artifactId, String version, String classifier, String type) {
        Element extension = this.addElement(extensionsElement, "extension");
        this.insertElementAtCorrectPosition(extension, "groupId", groupId);
        this.insertElementAtCorrectPosition(extension, "artifactId", artifactId);
        this.insertElementAtCorrectPosition(extension, "version", version);
        if (classifier != null) {
            this.insertElementAtCorrectPosition(extension, "classifier", classifier);
        }
        if (type != null) {
            this.insertElementAtCorrectPosition(extension, "type", type);
        }
        return extension;
    }

    public Element findChildElement(Element parent, String elementName) {
        Optional child = parent.child(elementName);
        return child.orElse(null);
    }

    @Override
    protected List<String> getOrderListForParent(Element parent) {
        String parentName;
        return switch (parentName = parent.name()) {
            case "extension" -> EXTENSION_ELEMENT_ORDER;
            default -> null;
        };
    }
}

