/*
 * Decompiled with CFR 0.152.
 */
package org.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.DomTripException;
import eu.maveniverse.domtrip.Element;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maveniverse.domtrip.maven.AbstractMavenEditor;

public class PomEditor
extends AbstractMavenEditor {
    private static final Map<String, List<String>> ELEMENT_ORDER = new HashMap<String, List<String>>();

    public PomEditor() {
    }

    public PomEditor(DomTripConfig config) {
        super(config);
    }

    public PomEditor(Document document) {
        super(document);
    }

    public PomEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    @Override
    protected List<String> getOrderListForParent(Element parent) {
        return ELEMENT_ORDER.get(parent.name());
    }

    @Override
    protected boolean shouldSkipInOrdering(String elementName) {
        return elementName.isEmpty();
    }

    @Override
    protected Element insertElementAtPosition(Element parent, String elementName, Element insertBefore, Element insertAfter, List<String> order, int elementIndex) throws DomTripException {
        boolean needsBlankLineBefore = this.needsBlankLineBefore(parent, order, elementIndex);
        boolean needsBlankLineAfter = this.needsBlankLineAfter(parent, order, elementIndex);
        Element newElement = insertBefore != null ? this.insertElementBefore(insertBefore, elementName) : (insertAfter != null ? this.insertElementAfter(insertAfter, elementName) : this.addElement(parent, elementName));
        if (needsBlankLineBefore) {
            this.addBlankLineBefore(newElement);
        }
        if (needsBlankLineAfter) {
            this.addBlankLineAfter(newElement);
        }
        return newElement;
    }

    public Element insertMavenElement(Element parent, String elementName) throws DomTripException {
        return this.insertElementAtCorrectPosition(parent, elementName, null);
    }

    public Element insertMavenElement(Element parent, String elementName, String textContent) throws DomTripException {
        return this.insertElementAtCorrectPosition(parent, elementName, textContent);
    }

    public Element findChildElement(Element parent, String elementName) {
        return parent.child(elementName).orElse(null);
    }

    public void createMavenDocument(String rootElementName) throws DomTripException {
        this.createDocument(rootElementName);
        if ("project".equals(rootElementName)) {
            Element root = this.root();
            root.attribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        }
    }

    public Element addDependency(Element dependenciesElement, String groupId, String artifactId, String version) throws DomTripException {
        Element dependency = this.insertMavenElement(dependenciesElement, "dependency");
        this.insertMavenElement(dependency, "groupId", groupId);
        this.insertMavenElement(dependency, "artifactId", artifactId);
        if (version != null && !version.trim().isEmpty()) {
            this.insertMavenElement(dependency, "version", version);
        }
        return dependency;
    }

    public Element addPlugin(Element pluginsElement, String groupId, String artifactId, String version) throws DomTripException {
        Element plugin = this.insertMavenElement(pluginsElement, "plugin");
        if (groupId != null && !groupId.trim().isEmpty()) {
            this.insertMavenElement(plugin, "groupId", groupId);
        }
        this.insertMavenElement(plugin, "artifactId", artifactId);
        if (version != null && !version.trim().isEmpty()) {
            this.insertMavenElement(plugin, "version", version);
        }
        return plugin;
    }

    public Element addModule(Element modulesElement, String moduleName) throws DomTripException {
        return this.insertMavenElement(modulesElement, "module", moduleName);
    }

    public Element addProperty(Element propertiesElement, String propertyName, String propertyValue) throws DomTripException {
        return this.addElement(propertiesElement, propertyName, propertyValue);
    }

    private boolean needsBlankLineBefore(Element parent, List<String> order, int elementIndex) {
        boolean hasElementsBefore = false;
        for (int i = 0; i < elementIndex; ++i) {
            String orderElement = order.get(i);
            if (orderElement.isEmpty() || !parent.child(orderElement).isPresent()) continue;
            hasElementsBefore = true;
            break;
        }
        return hasElementsBefore && elementIndex > 0 && order.get(elementIndex - 1).isEmpty();
    }

    private boolean needsBlankLineAfter(Element parent, List<String> order, int elementIndex) {
        boolean hasElementsAfter = false;
        for (int i = elementIndex + 2; i < order.size(); ++i) {
            String orderElement = order.get(i);
            if (orderElement.isEmpty() || !parent.child(orderElement).isPresent()) continue;
            hasElementsAfter = true;
            break;
        }
        return hasElementsAfter && elementIndex < order.size() - 1 && order.get(elementIndex + 1).isEmpty();
    }

    static {
        ELEMENT_ORDER.put("project", Arrays.asList("modelVersion", "", "parent", "", "groupId", "artifactId", "version", "packaging", "", "name", "description", "url", "inceptionYear", "organization", "licenses", "", "developers", "contributors", "", "mailingLists", "", "prerequisites", "", "modules", "", "scm", "issueManagement", "ciManagement", "distributionManagement", "", "properties", "", "dependencyManagement", "dependencies", "", "repositories", "pluginRepositories", "", "build", "", "reporting", "", "profiles"));
        ELEMENT_ORDER.put("build", Arrays.asList("defaultGoal", "directory", "finalName", "sourceDirectory", "scriptSourceDirectory", "testSourceDirectory", "outputDirectory", "testOutputDirectory", "extensions", "", "pluginManagement", "", "plugins"));
        ELEMENT_ORDER.put("plugin", Arrays.asList("groupId", "artifactId", "version", "extensions", "executions", "dependencies", "goals", "inherited", "configuration"));
        ELEMENT_ORDER.put("dependency", Arrays.asList("groupId", "artifactId", "version", "classifier", "type", "scope", "systemPath", "optional", "exclusions"));
    }
}

