/*
 * Decompiled with CFR 0.152.
 */
package org.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.maveniverse.domtrip.maven.AbstractMavenEditor;

public class SettingsEditor
extends AbstractMavenEditor {
    private static final List<String> SETTINGS_ELEMENT_ORDER = Arrays.asList("localRepository", "interactiveMode", "usePluginRegistry", "offline", "proxies", "servers", "mirrors", "profiles", "activeProfiles", "pluginGroups");
    private static final List<String> PROFILE_ELEMENT_ORDER = Arrays.asList("id", "activation", "properties", "repositories", "pluginRepositories");
    private static final List<String> SERVER_ELEMENT_ORDER = Arrays.asList("id", "username", "password", "privateKey", "passphrase", "filePermissions", "directoryPermissions", "configuration");
    private static final List<String> MIRROR_ELEMENT_ORDER = Arrays.asList("id", "name", "url", "mirrorOf", "layout", "mirrorOfLayouts", "blocked");
    private static final List<String> PROXY_ELEMENT_ORDER = Arrays.asList("id", "active", "protocol", "host", "port", "username", "password", "nonProxyHosts");

    public SettingsEditor() {
    }

    public SettingsEditor(DomTripConfig config) {
        super(config);
    }

    public SettingsEditor(Document document) {
        super(document);
    }

    public SettingsEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    public void createSettingsDocument() {
        this.createDocument("settings");
        Element root = this.root();
        root.attribute("xmlns", "http://maven.apache.org/SETTINGS/1.2.0");
        root.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.attribute("xsi:schemaLocation", "http://maven.apache.org/SETTINGS/1.2.0 https://maven.apache.org/xsd/settings-1.2.0.xsd");
    }

    public Element insertSettingsElement(Element parent, String elementName) {
        return this.insertSettingsElement(parent, elementName, null);
    }

    public Element insertSettingsElement(Element parent, String elementName, String textContent) {
        return this.insertElementAtCorrectPosition(parent, elementName, textContent);
    }

    public Element addServer(Element serversElement, String id, String username, String password) {
        Element server = this.addElement(serversElement, "server");
        this.insertElementAtCorrectPosition(server, "id", id);
        if (username != null) {
            this.insertElementAtCorrectPosition(server, "username", username);
        }
        if (password != null) {
            this.insertElementAtCorrectPosition(server, "password", password);
        }
        return server;
    }

    public Element addMirror(Element mirrorsElement, String id, String name, String url, String mirrorOf) {
        Element mirror = this.addElement(mirrorsElement, "mirror");
        this.insertElementAtCorrectPosition(mirror, "id", id);
        this.insertElementAtCorrectPosition(mirror, "name", name);
        this.insertElementAtCorrectPosition(mirror, "url", url);
        this.insertElementAtCorrectPosition(mirror, "mirrorOf", mirrorOf);
        return mirror;
    }

    public Element addProxy(Element proxiesElement, String id, String protocol, String host, int port) {
        Element proxy = this.addElement(proxiesElement, "proxy");
        this.insertElementAtCorrectPosition(proxy, "id", id);
        this.insertElementAtCorrectPosition(proxy, "protocol", protocol);
        this.insertElementAtCorrectPosition(proxy, "host", host);
        this.insertElementAtCorrectPosition(proxy, "port", String.valueOf(port));
        return proxy;
    }

    public Element addProfile(Element profilesElement, String id) {
        Element profile = this.addElement(profilesElement, "profile");
        this.insertElementAtCorrectPosition(profile, "id", id);
        return profile;
    }

    public Element addProperty(Element propertiesElement, String propertyName, String propertyValue) {
        return this.addElement(propertiesElement, propertyName, propertyValue);
    }

    public Element findChildElement(Element parent, String elementName) {
        Optional child = parent.child(elementName);
        return child.orElse(null);
    }

    @Override
    protected List<String> getOrderListForParent(Element parent) {
        String parentName;
        return switch (parentName = parent.name()) {
            case "settings" -> SETTINGS_ELEMENT_ORDER;
            case "profile" -> PROFILE_ELEMENT_ORDER;
            case "server" -> SERVER_ELEMENT_ORDER;
            case "mirror" -> MIRROR_ELEMENT_ORDER;
            case "proxy" -> PROXY_ELEMENT_ORDER;
            default -> null;
        };
    }
}

