/*
 * Decompiled with CFR 0.152.
 */
package org.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.maveniverse.domtrip.maven.AbstractMavenEditor;

public class ToolchainsEditor
extends AbstractMavenEditor {
    private static final List<String> TOOLCHAIN_ELEMENT_ORDER = Arrays.asList("type", "provides", "configuration");

    public ToolchainsEditor() {
    }

    public ToolchainsEditor(DomTripConfig config) {
        super(config);
    }

    public ToolchainsEditor(Document document) {
        super(document);
    }

    public ToolchainsEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    public void createToolchainsDocument() {
        this.createDocument("toolchains");
        Element root = this.root();
        root.attribute("xmlns", "http://maven.apache.org/TOOLCHAINS/1.1.0");
        root.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.attribute("xsi:schemaLocation", "http://maven.apache.org/TOOLCHAINS/1.1.0 https://maven.apache.org/xsd/toolchains-1.1.0.xsd");
    }

    public Element insertToolchainsElement(Element parent, String elementName) {
        return this.insertToolchainsElement(parent, elementName, null);
    }

    public Element insertToolchainsElement(Element parent, String elementName, String textContent) {
        return this.insertElementAtCorrectPosition(parent, elementName, textContent);
    }

    public Element addJdkToolchain(Element toolchainsElement, String version, String vendor, String jdkHome) {
        Element toolchain = this.addElement(toolchainsElement, "toolchain");
        this.insertElementAtCorrectPosition(toolchain, "type", "jdk");
        Element provides = this.insertElementAtCorrectPosition(toolchain, "provides", null);
        this.addElement(provides, "version", version);
        this.addElement(provides, "vendor", vendor);
        Element configuration = this.insertElementAtCorrectPosition(toolchain, "configuration", null);
        this.addElement(configuration, "jdkHome", jdkHome);
        return toolchain;
    }

    public Element addToolchain(Element toolchainsElement, String type) {
        Element toolchain = this.addElement(toolchainsElement, "toolchain");
        this.insertElementAtCorrectPosition(toolchain, "type", type);
        return toolchain;
    }

    public Element addNetBeansToolchain(Element toolchainsElement, String version, String installDir) {
        Element toolchain = this.addElement(toolchainsElement, "toolchain");
        this.insertElementAtCorrectPosition(toolchain, "type", "netbeans");
        Element provides = this.insertElementAtCorrectPosition(toolchain, "provides", null);
        this.addElement(provides, "version", version);
        Element configuration = this.insertElementAtCorrectPosition(toolchain, "configuration", null);
        this.addElement(configuration, "installDir", installDir);
        return toolchain;
    }

    public Element addProvides(Element toolchainElement, String key, String value) {
        Element provides = this.findChildElement(toolchainElement, "provides");
        if (provides == null) {
            provides = this.insertElementAtCorrectPosition(toolchainElement, "provides", null);
        }
        this.addElement(provides, key, value);
        return provides;
    }

    public Element addConfiguration(Element toolchainElement, String key, String value) {
        Element configuration = this.findChildElement(toolchainElement, "configuration");
        if (configuration == null) {
            configuration = this.insertElementAtCorrectPosition(toolchainElement, "configuration", null);
        }
        this.addElement(configuration, key, value);
        return configuration;
    }

    public Element findChildElement(Element parent, String elementName) {
        Optional child = parent.child(elementName);
        return child.orElse(null);
    }

    @Override
    protected List<String> getOrderListForParent(Element parent) {
        String parentName;
        return switch (parentName = parent.name()) {
            case "toolchain" -> TOOLCHAIN_ELEMENT_ORDER;
            default -> null;
        };
    }
}

