/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.DomTripException;
import eu.maveniverse.domtrip.Editor;
import eu.maveniverse.domtrip.Element;
import eu.maveniverse.domtrip.maven.Coordinates;
import java.util.List;
import java.util.Objects;

public abstract class AbstractMavenEditor
extends Editor {
    protected AbstractMavenEditor() {
    }

    protected AbstractMavenEditor(DomTripConfig config) {
        super(config);
    }

    protected AbstractMavenEditor(Document document) {
        super(document);
    }

    protected AbstractMavenEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    protected abstract List<String> getOrderListForParent(Element var1);

    protected Element insertElementAtCorrectPosition(Element parent, String elementName, String textContent) throws DomTripException {
        List<String> order = this.getOrderListForParent(parent);
        return this.insertElementAtCorrectPosition(parent, elementName, textContent, order);
    }

    protected Element insertElementAtCorrectPosition(Element parent, String elementName, String textContent, List<String> order) throws DomTripException {
        Element existing;
        int i;
        if (order == null) {
            Element element = this.addElement(parent, elementName);
            if (textContent != null && !textContent.isEmpty()) {
                element.textContent(textContent);
            }
            return element;
        }
        int newElementIndex = order.indexOf(elementName);
        if (newElementIndex == -1) {
            Element element = this.addElement(parent, elementName);
            if (textContent != null && !textContent.isEmpty()) {
                element.textContent(textContent);
            }
            return element;
        }
        Element insertAfter = null;
        Element insertBefore = null;
        for (i = newElementIndex - 1; i >= 0; --i) {
            String beforeElementName = order.get(i);
            if (this.shouldSkipInOrdering(beforeElementName) || (existing = (Element)parent.child(beforeElementName).orElse(null)) == null) continue;
            insertAfter = existing;
            break;
        }
        for (i = newElementIndex + 1; i < order.size(); ++i) {
            String afterElementName = order.get(i);
            if (this.shouldSkipInOrdering(afterElementName) || (existing = (Element)parent.child(afterElementName).orElse(null)) == null) continue;
            insertBefore = existing;
            break;
        }
        Element element = this.insertElementAtPosition(parent, elementName, insertBefore, insertAfter, order, newElementIndex);
        if (textContent != null && !textContent.isEmpty()) {
            element.textContent(textContent);
        }
        return element;
    }

    protected boolean shouldSkipInOrdering(String elementName) {
        return false;
    }

    protected Element insertElementAtPosition(Element parent, String elementName, Element insertBefore, Element insertAfter, List<String> order, int elementIndex) throws DomTripException {
        if (insertBefore != null) {
            return this.insertElementBefore(insertBefore, elementName);
        }
        if (insertAfter != null) {
            return this.insertElementAfter(insertAfter, elementName);
        }
        return this.addElement(parent, elementName);
    }

    public static String toGA(Element element) {
        Objects.requireNonNull(element);
        String groupId = element.childTextOr("groupId", null);
        String artifactId = element.childTextOr("artifactId", null);
        if (groupId == null || artifactId == null) {
            return null;
        }
        return groupId + ":" + artifactId;
    }

    public static String toPluginGA(Element element) {
        Objects.requireNonNull(element);
        String groupId = element.childTextOr("groupId", "org.apache.maven.plugins");
        String artifactId = element.childTextOr("artifactId", null);
        if (artifactId == null) {
            return null;
        }
        return groupId + ":" + artifactId;
    }

    public static String toGATC(Element element) {
        Objects.requireNonNull(element);
        String ga = AbstractMavenEditor.toGA(element);
        if (ga == null) {
            return null;
        }
        String type = element.childTextOr("type", "jar");
        String classifier = element.childTextOr("classifier", null);
        if (classifier != null) {
            return ga + ":" + type + ":" + classifier;
        }
        return ga + ":" + type;
    }

    public Coordinates toCoordinates(Element element, String extension) {
        Objects.requireNonNull(element);
        String groupId = element.childTextOr("groupId", null);
        String artifactId = element.childTextOr("artifactId", null);
        String version = element.childTextOr("version", null);
        String classifier = element.childTextOr("classifier", null);
        if (artifactId == null) {
            throw new DomTripException("artifactId is required but not found in element");
        }
        return Coordinates.of(groupId, artifactId, version, classifier, extension);
    }

    public Coordinates toJarCoordinates(Element element) {
        return this.toCoordinates(element, "jar");
    }

    public Coordinates toPomCoordinates(Element element) {
        return this.toCoordinates(element, "pom");
    }
}

