/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripException;
import eu.maveniverse.domtrip.Element;
import eu.maveniverse.domtrip.maven.AbstractMavenEditor;
import eu.maveniverse.domtrip.maven.PomEditor;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Predicate;

public record Coordinates(String groupId, String artifactId, String version, String classifier, String type) {
    public Coordinates {
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        if (artifactId.trim().isEmpty()) {
            throw new DomTripException("artifactId cannot be empty");
        }
        if (groupId != null && groupId.trim().isEmpty()) {
            throw new DomTripException("groupId cannot be empty (but can be null)");
        }
        if (version != null && version.trim().isEmpty()) {
            throw new DomTripException("version cannot be empty (but can be null)");
        }
        if (type == null || type.trim().isEmpty()) {
            type = "jar";
        }
        if (classifier != null && classifier.trim().isEmpty()) {
            classifier = null;
        }
    }

    public static Coordinates of(String groupId, String artifactId, String version) {
        return new Coordinates(groupId, artifactId, version, null, "jar");
    }

    public static Coordinates of(String groupId, String artifactId, String version, String classifier, String type) {
        return new Coordinates(groupId, artifactId, version, classifier, type);
    }

    public String toGA() {
        return this.groupId + ":" + this.artifactId;
    }

    public String toGAV() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toGATC() {
        if (this.classifier != null) {
            return this.groupId + ":" + this.artifactId + ":" + this.type + ":" + this.classifier;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.type;
    }

    public String toFullString() {
        if (this.classifier != null) {
            return this.groupId + ":" + this.artifactId + ":" + this.type + ":" + this.classifier + ":" + this.version;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.type + ":" + this.version;
    }

    public Coordinates withVersion(String newVersion) {
        return new Coordinates(this.groupId, this.artifactId, newVersion, this.classifier, this.type);
    }

    public Coordinates withType(String newType) {
        return new Coordinates(this.groupId, this.artifactId, this.version, this.classifier, newType);
    }

    public Predicate<Element> predicateGA() {
        return element -> {
            String elementGA = AbstractMavenEditor.toGA(element);
            return Objects.equals(elementGA, this.toGA());
        };
    }

    public Predicate<Element> predicatePluginGA() {
        return element -> {
            String elementGA = AbstractMavenEditor.toPluginGA(element);
            return Objects.equals(elementGA, this.toGA());
        };
    }

    public Predicate<Element> predicateGATC() {
        return element -> {
            String elementGATC = AbstractMavenEditor.toGATC(element);
            return Objects.equals(elementGATC, this.toGATC());
        };
    }

    public static Coordinates fromPom(Path pomPath) throws DomTripException {
        Element parent;
        Objects.requireNonNull(pomPath);
        PomEditor pomEditor = new PomEditor(Document.of((Path)pomPath));
        Element root = pomEditor.root();
        String groupId = root.childTextOr("groupId", null);
        String artifactId = root.childTextOr("artifactId", null);
        String version = root.childTextOr("version", null);
        if (artifactId == null) {
            throw new DomTripException("Malformed POM: artifactId is required but not found");
        }
        if ((groupId == null || version == null) && (parent = pomEditor.findChildElement(root, "parent")) != null) {
            if (groupId == null) {
                groupId = parent.childTextOr("groupId", null);
            }
            if (version == null) {
                version = parent.childTextOr("version", null);
            }
        }
        return Coordinates.of(groupId, artifactId, version, null, "pom");
    }
}

