/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.DomTripException;
import eu.maveniverse.domtrip.Element;
import eu.maveniverse.domtrip.maven.AbstractMavenEditor;
import eu.maveniverse.domtrip.maven.Coordinates;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class ExtensionsEditor
extends AbstractMavenEditor {
    private static final List<String> EXTENSION_ELEMENT_ORDER = Arrays.asList("groupId", "artifactId", "version", "classifier", "type", "configuration");

    public ExtensionsEditor() {
    }

    public ExtensionsEditor(DomTripConfig config) {
        super(config);
    }

    public ExtensionsEditor(Document document) {
        super(document);
    }

    public ExtensionsEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    public void createExtensionsDocument() throws DomTripException {
        this.createDocument("extensions");
        Element root = this.root();
        root.attribute("xmlns", "http://maven.apache.org/EXTENSIONS/1.2.0");
        root.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.attribute("xsi:schemaLocation", "http://maven.apache.org/EXTENSIONS/1.2.0 https://maven.apache.org/xsd/core-extensions-1.2.0.xsd");
    }

    public Element insertExtensionsElement(Element parent, String elementName) throws DomTripException {
        return this.insertExtensionsElement(parent, elementName, null);
    }

    public Element insertExtensionsElement(Element parent, String elementName, String textContent) throws DomTripException {
        return this.insertElementAtCorrectPosition(parent, elementName, textContent);
    }

    public Element addExtension(Element extensionsElement, String groupId, String artifactId, String version) throws DomTripException {
        return this.addExtension(extensionsElement, groupId, artifactId, version, null, null);
    }

    public Element addExtension(Element extensionsElement, String groupId, String artifactId, String version, String classifier, String type) throws DomTripException {
        Element extension = this.addElement(extensionsElement, "extension");
        this.insertElementAtCorrectPosition(extension, "groupId", groupId);
        this.insertElementAtCorrectPosition(extension, "artifactId", artifactId);
        this.insertElementAtCorrectPosition(extension, "version", version);
        if (classifier != null) {
            this.insertElementAtCorrectPosition(extension, "classifier", classifier);
        }
        if (type != null) {
            this.insertElementAtCorrectPosition(extension, "type", type);
        }
        return extension;
    }

    public Element findChildElement(Element parent, String elementName) {
        Optional child = parent.child(elementName);
        return child.orElse(null);
    }

    public List<Coordinates> listExtensions() throws DomTripException {
        return this.root().children("extension").map(this::toJarCoordinates).toList();
    }

    public boolean updateExtension(boolean upsert, Coordinates coordinates) throws DomTripException {
        List<Element> matched = this.root().children("extension").filter(coordinates.predicateGA()).toList();
        if (matched.isEmpty()) {
            if (upsert) {
                this.addExtension(this.root(), coordinates.groupId(), coordinates.artifactId(), coordinates.version());
                return true;
            }
            return false;
        }
        Element element = matched.get(0);
        this.findChildElement(element, "version").textContent(coordinates.version());
        if (matched.size() > 1) {
            System.err.println("Warning: More than one matching extension found: " + matched.size());
        }
        return true;
    }

    public boolean deleteExtension(Coordinates coordinates) throws DomTripException {
        AtomicInteger counter = new AtomicInteger(0);
        this.root().children("extension").filter(coordinates.predicateGA()).peek(e -> counter.incrementAndGet()).forEach(arg_0 -> ((ExtensionsEditor)this).removeElement(arg_0));
        return counter.get() != 0;
    }

    @Override
    protected List<String> getOrderListForParent(Element parent) {
        String parentName;
        return switch (parentName = parent.name()) {
            case "extension" -> EXTENSION_ELEMENT_ORDER;
            default -> null;
        };
    }
}

