/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.domtrip.maven;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.DomTripConfig;
import eu.maveniverse.domtrip.DomTripException;
import eu.maveniverse.domtrip.Element;
import eu.maveniverse.domtrip.maven.AbstractMavenEditor;
import eu.maveniverse.domtrip.maven.Coordinates;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class PomEditor
extends AbstractMavenEditor {
    private static final Map<String, List<String>> ELEMENT_ORDER = new HashMap<String, List<String>>();

    public PomEditor() {
    }

    public PomEditor(DomTripConfig config) {
        super(config);
    }

    public PomEditor(Document document) {
        super(document);
    }

    public PomEditor(Document document, DomTripConfig config) {
        super(document, config);
    }

    @Override
    protected List<String> getOrderListForParent(Element parent) {
        return ELEMENT_ORDER.get(parent.name());
    }

    @Override
    protected boolean shouldSkipInOrdering(String elementName) {
        return elementName.isEmpty();
    }

    @Override
    protected Element insertElementAtPosition(Element parent, String elementName, Element insertBefore, Element insertAfter, List<String> order, int elementIndex) throws DomTripException {
        boolean needsBlankLineBefore = this.needsBlankLineBefore(parent, order, elementIndex);
        boolean needsBlankLineAfter = this.needsBlankLineAfter(parent, order, elementIndex);
        Element newElement = insertBefore != null ? this.insertElementBefore(insertBefore, elementName) : (insertAfter != null ? this.insertElementAfter(insertAfter, elementName) : this.addElement(parent, elementName));
        if (needsBlankLineBefore) {
            this.addBlankLineBefore(newElement);
        }
        if (needsBlankLineAfter) {
            this.addBlankLineAfter(newElement);
        }
        return newElement;
    }

    public Element insertMavenElement(Element parent, String elementName) throws DomTripException {
        return this.insertElementAtCorrectPosition(parent, elementName, null);
    }

    public Element insertMavenElement(Element parent, String elementName, String textContent) throws DomTripException {
        return this.insertElementAtCorrectPosition(parent, elementName, textContent);
    }

    public Element findChildElement(Element parent, String elementName) {
        return parent.child(elementName).orElse(null);
    }

    public void createMavenDocument(String rootElementName) throws DomTripException {
        this.createDocument(rootElementName);
        if ("project".equals(rootElementName)) {
            Element root = this.root();
            root.attribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        }
    }

    public Dependencies dependencies() {
        return new Dependencies();
    }

    public Plugins plugins() {
        return new Plugins();
    }

    public Extensions extensions() {
        return new Extensions();
    }

    public Subprojects subprojects() {
        return new Subprojects();
    }

    public Properties properties() {
        return new Properties();
    }

    public Parent parent() {
        return new Parent();
    }

    public void setVersion(String value) throws DomTripException {
        Element parent;
        Element version = this.findChildElement(this.root(), "version");
        if (version == null && (parent = this.findChildElement(this.root(), "parent")) != null) {
            version = this.findChildElement(parent, "version");
        }
        if (version != null) {
            version.textContent(value);
            return;
        }
        throw new DomTripException("Could not set version");
    }

    public void setPackaging(String value) throws DomTripException {
        Element packaging = this.findChildElement(this.root(), "packaging");
        if (packaging == null) {
            this.insertMavenElement(this.root(), "packaging", value);
        } else {
            packaging.textContent(value);
        }
    }

    private boolean needsBlankLineBefore(Element parent, List<String> order, int elementIndex) {
        boolean hasElementsBefore = false;
        for (int i = 0; i < elementIndex; ++i) {
            String orderElement = order.get(i);
            if (orderElement.isEmpty() || !parent.child(orderElement).isPresent()) continue;
            hasElementsBefore = true;
            break;
        }
        return hasElementsBefore && elementIndex > 0 && order.get(elementIndex - 1).isEmpty();
    }

    private boolean needsBlankLineAfter(Element parent, List<String> order, int elementIndex) {
        boolean hasElementsAfter = false;
        for (int i = elementIndex + 2; i < order.size(); ++i) {
            String orderElement = order.get(i);
            if (orderElement.isEmpty() || !parent.child(orderElement).isPresent()) continue;
            hasElementsAfter = true;
            break;
        }
        return hasElementsAfter && elementIndex < order.size() - 1 && order.get(elementIndex + 1).isEmpty();
    }

    public boolean hasChildElement(Element parent, String childName) {
        return parent.child(childName).isPresent();
    }

    public String getChildElementText(Element parent, String childName) {
        return parent.child(childName).map(Element::textContent).orElse(null);
    }

    public Element updateOrCreateChildElement(Element parent, String childName, String content) throws DomTripException {
        Element child = this.findChildElement(parent, childName);
        if (child != null) {
            child.textContent(content);
            return child;
        }
        return this.insertMavenElement(parent, childName, content);
    }

    private boolean updateVersionElement(Element parent, String newVersion) throws DomTripException {
        Optional version = parent.child("version");
        if (version.isPresent()) {
            String versionValue = ((Element)version.orElseThrow()).textContent();
            if (versionValue != null && versionValue.startsWith("${") && versionValue.endsWith("}")) {
                String propertyKey = versionValue.substring(2, versionValue.length() - 1);
                return this.properties().updateProperty(false, propertyKey, newVersion);
            }
            ((Element)version.orElseThrow()).textContent(newVersion);
            return true;
        }
        return false;
    }

    static {
        ELEMENT_ORDER.put("project", Arrays.asList("modelVersion", "", "parent", "", "groupId", "artifactId", "version", "packaging", "", "name", "description", "url", "inceptionYear", "organization", "licenses", "", "developers", "contributors", "", "mailingLists", "", "prerequisites", "", "modules", "", "scm", "issueManagement", "ciManagement", "distributionManagement", "", "properties", "", "dependencyManagement", "dependencies", "", "repositories", "pluginRepositories", "", "build", "", "reporting", "", "profiles"));
        ELEMENT_ORDER.put("build", Arrays.asList("defaultGoal", "directory", "finalName", "sourceDirectory", "scriptSourceDirectory", "testSourceDirectory", "outputDirectory", "testOutputDirectory", "extensions", "", "pluginManagement", "", "plugins"));
        ELEMENT_ORDER.put("plugin", Arrays.asList("groupId", "artifactId", "version", "extensions", "executions", "dependencies", "goals", "inherited", "configuration"));
        ELEMENT_ORDER.put("dependency", Arrays.asList("groupId", "artifactId", "version", "classifier", "type", "scope", "systemPath", "optional", "exclusions"));
    }

    public class Dependencies {
        public Element addDependency(Element dependenciesElement, String groupId, String artifactId, String version) throws DomTripException {
            Element dependency = PomEditor.this.insertMavenElement(dependenciesElement, "dependency");
            PomEditor.this.insertMavenElement(dependency, "groupId", groupId);
            PomEditor.this.insertMavenElement(dependency, "artifactId", artifactId);
            if (version != null && !version.trim().isEmpty()) {
                PomEditor.this.insertMavenElement(dependency, "version", version);
            }
            return dependency;
        }

        public boolean updateManagedDependency(boolean upsert, Coordinates coordinates) throws DomTripException {
            Element root = PomEditor.this.root();
            Element dependencyManagement = PomEditor.this.findChildElement(root, "dependencyManagement");
            if (dependencyManagement == null && upsert) {
                dependencyManagement = PomEditor.this.insertMavenElement(root, "dependencyManagement");
            }
            if (dependencyManagement != null) {
                Element dependencies = PomEditor.this.findChildElement(dependencyManagement, "dependencies");
                if (dependencies == null && upsert) {
                    dependencies = PomEditor.this.insertMavenElement(dependencyManagement, "dependencies");
                }
                if (dependencies != null) {
                    Element dependency = dependencies.children("dependency").filter(coordinates.predicateGATC()).findFirst().orElse(null);
                    if (dependency == null && upsert) {
                        dependency = this.addDependency(dependencies, coordinates.groupId(), coordinates.artifactId(), coordinates.version());
                        if (coordinates.type() != null && !"jar".equals(coordinates.type())) {
                            PomEditor.this.insertMavenElement(dependency, "type", coordinates.type());
                        }
                        if (coordinates.classifier() != null) {
                            PomEditor.this.insertMavenElement(dependency, "classifier", coordinates.classifier());
                        }
                        return true;
                    }
                    if (dependency != null) {
                        return PomEditor.this.updateVersionElement(dependency, coordinates.version());
                    }
                }
            }
            return false;
        }

        public boolean deleteManagedDependency(Coordinates coordinates) throws DomTripException {
            Element dependency;
            Element dependencies;
            Element dependencyManagement = PomEditor.this.findChildElement(PomEditor.this.root(), "dependencyManagement");
            if (dependencyManagement != null && (dependencies = PomEditor.this.findChildElement(dependencyManagement, "dependencies")) != null && (dependency = (Element)dependencies.children("dependency").filter(coordinates.predicateGATC()).findFirst().orElse(null)) != null) {
                return PomEditor.this.removeElement(dependency);
            }
            return false;
        }

        public boolean updateDependency(boolean upsert, Coordinates coordinates) throws DomTripException {
            Element dependencies = PomEditor.this.findChildElement(PomEditor.this.root(), "dependencies");
            if (dependencies == null && upsert) {
                dependencies = PomEditor.this.insertMavenElement(PomEditor.this.root(), "dependencies");
            }
            if (dependencies != null) {
                Element dependency = dependencies.children("dependency").filter(coordinates.predicateGATC()).findFirst().orElse(null);
                if (dependency == null && upsert) {
                    dependency = this.addDependency(dependencies, coordinates.groupId(), coordinates.artifactId(), coordinates.version());
                    if (coordinates.type() != null && !"jar".equals(coordinates.type())) {
                        PomEditor.this.insertMavenElement(dependency, "type", coordinates.type());
                    }
                    if (coordinates.classifier() != null) {
                        PomEditor.this.insertMavenElement(dependency, "classifier", coordinates.classifier());
                    }
                    return true;
                }
                if (dependency != null) {
                    Optional version = dependency.child("version");
                    if (version.isPresent()) {
                        return PomEditor.this.updateVersionElement(dependency, coordinates.version());
                    }
                    return this.updateManagedDependency(false, coordinates);
                }
            }
            return false;
        }

        public boolean deleteDependency(Coordinates coordinates) throws DomTripException {
            Element dependency;
            Element dependencies = PomEditor.this.findChildElement(PomEditor.this.root(), "dependencies");
            if (dependencies != null && (dependency = (Element)dependencies.children("dependency").filter(coordinates.predicateGATC()).findFirst().orElse(null)) != null) {
                return PomEditor.this.removeElement(dependency);
            }
            return false;
        }

        public boolean deleteDependencyVersion(Coordinates coordinates) throws DomTripException {
            Element dependency;
            Element dependencies = PomEditor.this.findChildElement(PomEditor.this.root(), "dependencies");
            if (dependencies != null && (dependency = (Element)dependencies.children("dependency").filter(coordinates.predicateGATC()).findFirst().orElse(null)) != null) {
                return dependency.child("version").map(arg_0 -> ((PomEditor)PomEditor.this).removeElement(arg_0)).isPresent();
            }
            return false;
        }
    }

    public class Plugins {
        public Element addPlugin(Element pluginsElement, String groupId, String artifactId, String version) throws DomTripException {
            Element plugin = PomEditor.this.insertMavenElement(pluginsElement, "plugin");
            if (groupId != null && !groupId.trim().isEmpty()) {
                PomEditor.this.insertMavenElement(plugin, "groupId", groupId);
            }
            PomEditor.this.insertMavenElement(plugin, "artifactId", artifactId);
            if (version != null && !version.trim().isEmpty()) {
                PomEditor.this.insertMavenElement(plugin, "version", version);
            }
            return plugin;
        }

        private Element findOrCreateManagedPlugins(boolean upsert) throws DomTripException {
            Element root = PomEditor.this.root();
            Element build = PomEditor.this.findChildElement(root, "build");
            if (build == null && upsert) {
                build = PomEditor.this.insertMavenElement(root, "build");
            }
            if (build != null) {
                Element pluginManagement = PomEditor.this.findChildElement(build, "pluginManagement");
                if (pluginManagement == null && upsert) {
                    pluginManagement = PomEditor.this.insertMavenElement(build, "pluginManagement");
                }
                if (pluginManagement != null) {
                    Element plugins = PomEditor.this.findChildElement(pluginManagement, "plugins");
                    if (plugins == null && upsert) {
                        plugins = PomEditor.this.insertMavenElement(pluginManagement, "plugins");
                    }
                    return plugins;
                }
            }
            return null;
        }

        private Element findOrCreatePlugins(boolean upsert) throws DomTripException {
            Element build = PomEditor.this.findChildElement(PomEditor.this.root(), "build");
            if (build == null && upsert) {
                build = PomEditor.this.insertMavenElement(PomEditor.this.root(), "build");
            }
            if (build != null) {
                Element plugins = PomEditor.this.findChildElement(build, "plugins");
                if (plugins == null && upsert) {
                    plugins = PomEditor.this.insertMavenElement(build, "plugins");
                }
                return plugins;
            }
            return null;
        }

        private Element findPlugin(Element plugins, Coordinates coordinates) {
            if (plugins == null) {
                return null;
            }
            return plugins.children("plugin").filter(coordinates.predicateGA()).findFirst().orElse(null);
        }

        public boolean deleteManagedPlugin(Coordinates coordinates) throws DomTripException {
            Element plugins = this.findOrCreateManagedPlugins(false);
            Element plugin = this.findPlugin(plugins, coordinates);
            if (plugin != null) {
                return PomEditor.this.removeElement(plugin);
            }
            return false;
        }

        public boolean updatePlugin(boolean upsert, Coordinates coordinates) throws DomTripException {
            Element plugins = this.findOrCreatePlugins(upsert);
            if (plugins != null) {
                Element plugin = this.findPlugin(plugins, coordinates);
                if (plugin == null && upsert) {
                    this.addPlugin(plugins, coordinates.groupId(), coordinates.artifactId(), coordinates.version());
                    return true;
                }
                if (plugin != null) {
                    Optional version = plugin.child("version");
                    if (version.isPresent()) {
                        return PomEditor.this.updateVersionElement(plugin, coordinates.version());
                    }
                    return this.updateManagedPlugin(false, coordinates);
                }
            }
            return false;
        }

        public boolean deletePlugin(Coordinates coordinates) throws DomTripException {
            Element plugins = this.findOrCreatePlugins(false);
            Element plugin = this.findPlugin(plugins, coordinates);
            if (plugin != null) {
                return PomEditor.this.removeElement(plugin);
            }
            return false;
        }

        public boolean deletePluginVersion(Coordinates coordinates) throws DomTripException {
            Element plugins = this.findOrCreatePlugins(false);
            Element plugin = this.findPlugin(plugins, coordinates);
            if (plugin != null) {
                return plugin.child("version").filter(arg_0 -> ((Element)plugin).removeNode(arg_0)).isPresent();
            }
            return false;
        }

        public boolean updateManagedPlugin(boolean upsert, Coordinates coordinates) throws DomTripException {
            Element plugins = this.findOrCreateManagedPlugins(upsert);
            if (plugins != null) {
                Element plugin = this.findPlugin(plugins, coordinates);
                if (plugin == null && upsert) {
                    this.addPlugin(plugins, coordinates.groupId(), coordinates.artifactId(), coordinates.version());
                    return true;
                }
                if (plugin != null) {
                    return PomEditor.this.updateVersionElement(plugin, coordinates.version());
                }
            }
            return false;
        }
    }

    public class Extensions {
        public Element addExtension(Element extensionsElement, String groupId, String artifactId, String version) throws DomTripException {
            Element extension = PomEditor.this.insertMavenElement(extensionsElement, "extension");
            PomEditor.this.insertMavenElement(extension, "groupId", groupId);
            PomEditor.this.insertMavenElement(extension, "artifactId", artifactId);
            PomEditor.this.insertMavenElement(extension, "version", version);
            return extension;
        }

        private Element findOrCreateExtensions(boolean upsert) throws DomTripException {
            Element build = PomEditor.this.findChildElement(PomEditor.this.root(), "build");
            if (build == null && upsert) {
                build = PomEditor.this.insertMavenElement(PomEditor.this.root(), "build");
            }
            if (build != null) {
                Element extensions = PomEditor.this.findChildElement(build, "extensions");
                if (extensions == null && upsert) {
                    extensions = PomEditor.this.insertMavenElement(build, "extensions");
                }
                return extensions;
            }
            return null;
        }

        private Element findExtension(Element extensions, Coordinates coordinates) {
            if (extensions == null) {
                return null;
            }
            return extensions.children("extension").filter(coordinates.predicateGA()).findFirst().orElse(null);
        }

        public boolean updateExtension(boolean upsert, Coordinates coordinates) throws DomTripException {
            Element extensions = this.findOrCreateExtensions(upsert);
            if (extensions != null) {
                Optional version;
                Element extension = this.findExtension(extensions, coordinates);
                if (extension == null && upsert) {
                    this.addExtension(extensions, coordinates.groupId(), coordinates.artifactId(), coordinates.version());
                    return true;
                }
                if (extension != null && (version = extension.child("version")).isPresent()) {
                    return PomEditor.this.updateVersionElement(extension, coordinates.version());
                }
            }
            return false;
        }

        public boolean deleteExtension(Coordinates coordinates) throws DomTripException {
            Element extensions = this.findOrCreateExtensions(false);
            Element extension = this.findExtension(extensions, coordinates);
            if (extension != null) {
                return PomEditor.this.removeElement(extension);
            }
            return false;
        }
    }

    public class Subprojects {
        public Element addModule(Element modulesElement, String moduleName) throws DomTripException {
            return PomEditor.this.insertMavenElement(modulesElement, "module", moduleName);
        }

        public boolean addSubProject(String moduleName) throws DomTripException {
            List<String> existing;
            Element modules = PomEditor.this.findChildElement(PomEditor.this.root(), "modules");
            if (modules == null) {
                modules = PomEditor.this.insertMavenElement(PomEditor.this.root(), "modules");
            }
            if (!(existing = modules.children("module").map(Element::textContent).toList()).contains(moduleName)) {
                PomEditor.this.insertMavenElement(modules, "module", moduleName);
                return true;
            }
            return false;
        }

        public boolean removeSubProject(String moduleName) throws DomTripException {
            Element modules = PomEditor.this.findChildElement(PomEditor.this.root(), "modules");
            if (modules == null) {
                return false;
            }
            AtomicBoolean removed = new AtomicBoolean(false);
            modules.children("module").filter(e -> Objects.equals(moduleName, e.textContent())).peek(e -> removed.set(true)).forEach(arg_0 -> ((PomEditor)PomEditor.this).removeElement(arg_0));
            return removed.get();
        }
    }

    public class Properties {
        public Element addProperty(Element propertiesElement, String propertyName, String propertyValue) throws DomTripException {
            return PomEditor.this.addElement(propertiesElement, propertyName, propertyValue);
        }

        public boolean updateProperty(boolean upsert, String key, String value) throws DomTripException {
            Element properties = PomEditor.this.root().child("properties").orElse(null);
            if (properties == null && upsert) {
                properties = PomEditor.this.insertMavenElement(PomEditor.this.root(), "properties");
            }
            if (properties != null) {
                Element property = properties.child(key).orElse(null);
                if (property == null && upsert) {
                    property = PomEditor.this.addElement(properties, key);
                }
                if (property != null) {
                    property.textContent(value);
                    return true;
                }
            }
            return false;
        }

        public boolean deleteProperty(String key) throws DomTripException {
            Element property;
            Element properties = PomEditor.this.root().child("properties").orElse(null);
            if (properties != null && (property = (Element)properties.child(key).orElse(null)) != null) {
                PomEditor.this.removeElement(property);
                return true;
            }
            return false;
        }
    }

    public class Parent {
        public void setParent(Coordinates coordinates) throws DomTripException {
            Element parent = PomEditor.this.findChildElement(PomEditor.this.root(), "parent");
            if (parent == null) {
                parent = PomEditor.this.insertMavenElement(PomEditor.this.root(), "parent");
            }
            PomEditor.this.insertMavenElement(parent, "groupId", coordinates.groupId());
            PomEditor.this.insertMavenElement(parent, "artifactId", coordinates.artifactId());
            PomEditor.this.insertMavenElement(parent, "version", coordinates.version());
        }

        public boolean updateParent(boolean upsert, Coordinates coordinates) throws DomTripException {
            Element parent = PomEditor.this.findChildElement(PomEditor.this.root(), "parent");
            if (parent == null && upsert) {
                parent = PomEditor.this.insertMavenElement(PomEditor.this.root(), "parent");
            }
            if (parent != null) {
                if (coordinates.groupId() != null && !coordinates.groupId().trim().isEmpty()) {
                    PomEditor.this.insertMavenElement(parent, "groupId", coordinates.groupId());
                }
                PomEditor.this.insertMavenElement(parent, "artifactId", coordinates.artifactId());
                if (coordinates.version() != null && !coordinates.version().trim().isEmpty()) {
                    PomEditor.this.insertMavenElement(parent, "version", coordinates.version());
                }
                return true;
            }
            return false;
        }

        public boolean deleteParent() throws DomTripException {
            Element parent = PomEditor.this.findChildElement(PomEditor.this.root(), "parent");
            return parent != null && PomEditor.this.removeElement(parent);
        }
    }
}

