/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.maven;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.HTTPProxy;
import eu.maveniverse.maven.mima.context.Lookup;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.context.internal.MavenSystemHomeImpl;
import eu.maveniverse.maven.mima.context.internal.MavenUserHomeImpl;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import eu.maveniverse.maven.mima.runtime.maven.internal.PlexusLookup;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;

@Singleton
@Named
public final class MavenRuntime
extends RuntimeSupport {
    private final RepositorySystem repositorySystem;
    private final PlexusContainer plexusContainer;
    private final Provider<MavenSession> mavenSessionProvider;

    @Inject
    public MavenRuntime(RepositorySystem repositorySystem, PlexusContainer plexusContainer, Provider<MavenSession> mavenSessionProvider, RuntimeInformation rt) {
        super("embedded-maven", MavenRuntime.discoverArtifactVersion((String)"eu.maveniverse.maven.mima.runtime", (String)"embedded-maven", (String)"(unknown)"), 10, MavenRuntime.mavenVersion(rt));
        this.repositorySystem = repositorySystem;
        this.plexusContainer = plexusContainer;
        this.mavenSessionProvider = mavenSessionProvider;
    }

    private static String mavenVersion(RuntimeInformation runtimeInformation) {
        String mavenVersion = runtimeInformation.getMavenVersion();
        if (mavenVersion == null || mavenVersion.trim().isEmpty()) {
            return "(unknown)";
        }
        return mavenVersion;
    }

    public boolean managedRepositorySystem() {
        return false;
    }

    public Context create(ContextOverrides overrides) {
        MavenSession mavenSession = (MavenSession)this.mavenSessionProvider.get();
        boolean projectPresent = mavenSession.getRequest().isProjectPresent();
        Path basedir = projectPresent ? mavenSession.getCurrentProject().getBasedir().toPath().toAbsolutePath() : DEFAULT_BASEDIR;
        MavenUserHome mavenUserHome = this.discoverMavenUserHome(mavenSession.getRequest());
        MavenSystemHome mavenSystemHome = this.discoverMavenSystemHome(mavenSession.getRequest());
        RepositorySystemSession session = mavenSession.getRepositorySession();
        ContextOverrides.Builder effectiveOverridesBuilder = overrides.toBuilder();
        effectiveOverridesBuilder.withUserSettings(true);
        if (projectPresent) {
            effectiveOverridesBuilder.repositories(mavenSession.getCurrentProject().getRemoteProjectRepositories());
        }
        effectiveOverridesBuilder.systemProperties(session.getSystemProperties());
        effectiveOverridesBuilder.userProperties(session.getUserProperties());
        effectiveOverridesBuilder.configProperties(session.getConfigProperties());
        ContextOverrides effective = effectiveOverridesBuilder.build();
        return this.customizeContext(this, overrides, new Context((RuntimeSupport)this, effective, basedir, mavenUserHome, mavenSystemHome, this.repositorySystem, session, this.repositorySystem.newResolutionRepositories(session, effective.getRepositories()), this.toHTTPProxy(mavenSession.getSettings().getActiveProxy()), (Lookup)new PlexusLookup(this.plexusContainer), null), false);
    }

    private HTTPProxy toHTTPProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        if (proxy.getUsername() != null) {
            data.put("username", proxy.getUsername());
        }
        if (proxy.getPassword() != null) {
            data.put("password", proxy.getPassword());
        }
        return new HTTPProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getNonProxyHosts(), data);
    }

    private MavenUserHome discoverMavenUserHome(MavenExecutionRequest executionRequest) {
        return new MavenUserHomeImpl(DEFAULT_MAVEN_USER_HOME, executionRequest.getUserSettingsFile() != null ? executionRequest.getUserSettingsFile().toPath().toAbsolutePath() : null, null, executionRequest.getUserToolchainsFile() != null ? executionRequest.getUserToolchainsFile().toPath().toAbsolutePath() : null, executionRequest.getLocalRepositoryPath().toPath().toAbsolutePath());
    }

    private MavenSystemHome discoverMavenSystemHome(MavenExecutionRequest executionRequest) {
        return new MavenSystemHomeImpl(Paths.get(System.getProperty("maven.home"), new String[0]).toAbsolutePath(), executionRequest.getGlobalSettingsFile() != null ? executionRequest.getGlobalSettingsFile().toPath().toAbsolutePath() : null, executionRequest.getGlobalToolchainsFile() != null ? executionRequest.getGlobalToolchainsFile().toPath().toAbsolutePath() : null);
    }
}

