/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http.RFC9457;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URI;
import org.eclipse.aether.transport.http.RFC9457.RFC9457Payload;

public class RFC9457Parser {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)RFC9457Payload.class), new RFC9457PayloadAdapter()).create();

    public static RFC9457Payload parse(String data) {
        return GSON.fromJson(data, RFC9457Payload.class);
    }

    private static Integer parseStatus(JsonObject jsonObject) {
        return jsonObject.get("status") == null || jsonObject.get("status").isJsonNull() ? null : Integer.valueOf(jsonObject.get("status").getAsInt());
    }

    private static String parseNullableString(JsonObject jsonObject, String key) {
        return jsonObject.get(key) == null || jsonObject.get(key).isJsonNull() ? null : jsonObject.get(key).getAsString();
    }

    private static URI parseNullableURI(JsonObject jsonObject, String key, String defaultValue) {
        return !jsonObject.has(key) || jsonObject.get(key).isJsonNull() ? (defaultValue != null ? URI.create(defaultValue) : null) : URI.create(jsonObject.get(key).getAsString());
    }

    private static class RFC9457PayloadAdapter
    implements JsonDeserializer<RFC9457Payload> {
        private RFC9457PayloadAdapter() {
        }

        @Override
        public RFC9457Payload deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject asJsonObject = json.getAsJsonObject();
            URI type = RFC9457Parser.parseNullableURI(asJsonObject, "type", "about:blank");
            Integer status = RFC9457Parser.parseStatus(asJsonObject);
            String title = RFC9457Parser.parseNullableString(asJsonObject, "title");
            String detail = RFC9457Parser.parseNullableString(asJsonObject, "detail");
            URI instance = RFC9457Parser.parseNullableURI(asJsonObject, "instance", null);
            return new RFC9457Payload(type, status, title, detail, instance);
        }
    }
}

