/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon.protocol;

import eu.maveniverse.maven.mimir.daemon.protocol.Message;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Request", generator="Immutables")
public final class ImmutableRequest
extends Request {
    private final Map<String, String> data;
    private final Map<String, String> session;
    private final String cmd;

    private ImmutableRequest(Map<String, String> data, Map<String, String> session, String cmd) {
        this.data = data;
        this.session = session;
        this.cmd = cmd;
    }

    @Override
    public Map<String, String> data() {
        return this.data;
    }

    @Override
    public Map<String, String> session() {
        return this.session;
    }

    @Override
    public String cmd() {
        return this.cmd;
    }

    public final ImmutableRequest withData(Map<String, ? extends String> entries) {
        if (this.data == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableRequest(newValue, this.session, this.cmd);
    }

    public final ImmutableRequest withSession(Map<String, ? extends String> entries) {
        if (this.session == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableRequest(this.data, newValue, this.cmd);
    }

    public final ImmutableRequest withCmd(String value) {
        String newValue = Objects.requireNonNull(value, "cmd");
        if (this.cmd.equals(newValue)) {
            return this;
        }
        return new ImmutableRequest(this.data, this.session, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequest && this.equalsByValue((ImmutableRequest)another);
    }

    private boolean equalsByValue(ImmutableRequest another) {
        return this.data.equals(another.data) && this.session.equals(another.session) && this.cmd.equals(another.cmd);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.session.hashCode();
        h += (h << 5) + this.cmd.hashCode();
        return h;
    }

    public String toString() {
        return "Request{data=" + String.valueOf(this.data) + ", session=" + String.valueOf(this.session) + ", cmd=" + this.cmd + "}";
    }

    public static ImmutableRequest copyOf(Request instance) {
        if (instance instanceof ImmutableRequest) {
            return (ImmutableRequest)instance;
        }
        return ImmutableRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Request", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CMD = 1L;
        private long initBits = 1L;
        private Map<String, String> data = new LinkedHashMap<String, String>();
        private Map<String, String> session = new LinkedHashMap<String, String>();
        private String cmd;

        private Builder() {
        }

        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Request instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Message instance;
            long bits = 0L;
            if (object instanceof Message) {
                instance = (Message)object;
                this.putAllData(instance.data());
                this.putAllSession(instance.session());
            }
            if (object instanceof Request) {
                instance = (Request)object;
                this.cmd(((Request)instance).cmd());
            }
        }

        public final Builder putData(String key, String value) {
            this.data.put(Objects.requireNonNull(key, "data key"), Objects.requireNonNull(value, value == null ? "data value for key: " + key : null));
            return this;
        }

        public final Builder putData(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.data.put(Objects.requireNonNull(k, "data key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "data value for key: " + k : null));
            return this;
        }

        public final Builder data(Map<String, ? extends String> entries) {
            this.data.clear();
            return this.putAllData(entries);
        }

        public final Builder putAllData(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.data.put(Objects.requireNonNull(k, "data key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "data value for key: " + k : null));
            }
            return this;
        }

        public final Builder putSession(String key, String value) {
            this.session.put(Objects.requireNonNull(key, "session key"), Objects.requireNonNull(value, value == null ? "session value for key: " + key : null));
            return this;
        }

        public final Builder putSession(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.session.put(Objects.requireNonNull(k, "session key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "session value for key: " + k : null));
            return this;
        }

        public final Builder session(Map<String, ? extends String> entries) {
            this.session.clear();
            return this.putAllSession(entries);
        }

        public final Builder putAllSession(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.session.put(Objects.requireNonNull(k, "session key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "session value for key: " + k : null));
            }
            return this;
        }

        public final Builder cmd(String cmd) {
            this.cmd = Objects.requireNonNull(cmd, "cmd");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequest(ImmutableRequest.createUnmodifiableMap(false, false, this.data), ImmutableRequest.createUnmodifiableMap(false, false, this.session), this.cmd);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cmd");
            }
            return "Cannot build Request, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

