/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon.protocol;

import eu.maveniverse.maven.mimir.daemon.protocol.ImmutableResponse;
import eu.maveniverse.maven.mimir.daemon.protocol.Message;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Response
extends Message {
    public static final String STATUS_OK = "OK";
    public static final String STATUS_KO = "KO ";
    public static final String DATA_MESSAGE = "message";

    public abstract String status();

    public static Response okMessage(Request request, String message) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(message, DATA_MESSAGE);
        return Response.response(request, STATUS_OK, Map.of(DATA_MESSAGE, message));
    }

    public static Response okData(Request request, Map<String, String> data) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(data, "data");
        return Response.response(request, STATUS_OK, data);
    }

    public static Response koMessage(Request request, String message) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(message, DATA_MESSAGE);
        return Response.response(request, STATUS_KO, Map.of(DATA_MESSAGE, message));
    }

    private static Response response(Request request, String status, Map<String, String> data) {
        return ImmutableResponse.builder().status(status).data(data).session(request.session()).build();
    }
}

