/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.nio.file.Path;
import java.util.Objects;

public class DaemonConfig {
    private final SessionConfig sessionConfig;
    private final Path daemonLockDir;
    private final Path socketPath;
    private final String systemNode;

    public static DaemonConfig with(SessionConfig sessionConfig) {
        Objects.requireNonNull(sessionConfig, "config");
        Path daemonLockDir = sessionConfig.basedir().resolve("daemon");
        Path socketPath = sessionConfig.basedir().resolve("mimir-socket");
        String systemNode = "file";
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.socketPath")) {
            socketPath = FileUtils.canonicalPath(sessionConfig.basedir().resolve(sessionConfig.effectiveProperties().get("mimir.daemon.socketPath")));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.systemNode")) {
            systemNode = sessionConfig.effectiveProperties().get("mimir.daemon.systemNode");
        }
        return new DaemonConfig(sessionConfig, daemonLockDir, socketPath, systemNode);
    }

    private DaemonConfig(SessionConfig sessionConfig, Path daemonLockDir, Path socketPath, String systemNode) {
        this.sessionConfig = Objects.requireNonNull(sessionConfig);
        this.daemonLockDir = Objects.requireNonNull(daemonLockDir);
        this.socketPath = Objects.requireNonNull(socketPath);
        this.systemNode = Objects.requireNonNull(systemNode);
    }

    public SessionConfig config() {
        return this.sessionConfig;
    }

    public Path daemonLockDir() {
        return this.daemonLockDir;
    }

    public Path socketPath() {
        return this.socketPath;
    }

    public String systemNode() {
        return this.systemNode;
    }
}

