/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon;

import eu.maveniverse.maven.mimir.daemon.protocol.Handle;
import eu.maveniverse.maven.mimir.daemon.protocol.ImmutableResponse;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import eu.maveniverse.maven.mimir.daemon.protocol.Response;
import eu.maveniverse.maven.mimir.shared.impl.Utils;
import eu.maveniverse.maven.mimir.shared.node.Entry;
import eu.maveniverse.maven.mimir.shared.node.RemoteNode;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;

final class DaemonServer
extends ComponentSupport
implements Runnable {
    private final Handle handle;
    private final Map<String, String> daemonData;
    private final SystemNode<?> systemNode;
    private final List<RemoteNode<?>> remoteNodes;
    private final Predicate<Request> clientPredicate;
    private final Runnable shutdownHook;
    private final Map<String, Map<String, String>> sessions;

    DaemonServer(Handle handle, Map<String, String> daemonData, SystemNode<?> systemNode, List<RemoteNode<?>> remoteNodes, Predicate<Request> clientPredicate, Runnable shutdownHook) {
        this.handle = handle;
        this.daemonData = daemonData;
        this.systemNode = systemNode;
        this.remoteNodes = remoteNodes;
        this.clientPredicate = clientPredicate;
        this.shutdownHook = shutdownHook;
        this.sessions = new HashMap<String, Map<String, String>>();
    }

    @Override
    public void run() {
        try (Handle handle = this.handle;){
            Thread.currentThread().setName("DVT");
            Request request = this.handle.readRequest();
            try {
                switch (request.cmd()) {
                    case "HELLO": {
                        if (this.clientPredicate.test(request)) {
                            String sessionId = UUID.randomUUID().toString();
                            HashMap<String, String> session = new HashMap<String, String>();
                            session.put("sessionId", sessionId);
                            this.handle.writeResponse(ImmutableResponse.builder().status("OK").session(session).data(this.daemonData).build());
                            this.sessions.put(sessionId, request.data());
                            this.logger.debug("{} {} > {}", request.cmd(), request.data(), sessionId);
                            break;
                        }
                        this.handle.writeResponse(Response.koMessage(request, "Bad client; align both versions"));
                        this.logger.debug("{} {} > REJECT", (Object)request.cmd(), (Object)request.data());
                        break;
                    }
                    case "BYE": {
                        String sessionId = request.session().get("sessionId");
                        if (sessionId != null) {
                            this.sessions.remove(sessionId);
                        }
                        this.logger.debug("{} {} < {}", request.cmd(), request.data(), sessionId);
                        this.handle.writeResponse(Response.okMessage(request, "So Long, and Thanks for All the Fish"));
                        if (Boolean.parseBoolean(request.data().getOrDefault("shutdown", "false"))) {
                            this.shutdownHook.run();
                        }
                        break;
                    }
                    case "LOCATE": {
                        String keyString = request.requireData("keyString");
                        URI key = URI.create(keyString);
                        Optional<Object> entry = this.systemNode.locate(key);
                        if (entry.isEmpty()) {
                            for (RemoteNode<?> node : this.remoteNodes) {
                                Optional remoteEntry = node.locate(key);
                                if (!remoteEntry.isPresent()) continue;
                                entry = Optional.of(this.systemNode.store(key, (Entry)remoteEntry.orElseThrow()));
                                break;
                            }
                        }
                        this.logger.debug("{} {} {}", request.cmd(), entry.isPresent() ? "HIT" : "MISS", keyString);
                        if (entry.isPresent()) {
                            Entry entryValue = (Entry)entry.orElseThrow();
                            this.handle.writeResponse(Response.okData(request, Utils.mergeEntry(entryValue)));
                            break;
                        }
                        this.handle.writeResponse(Response.okData(request, Map.of()));
                        break;
                    }
                    case "TRANSFER": {
                        String keyString = request.requireData("keyString");
                        String pathString = request.requireData("pathString");
                        URI key = URI.create(keyString);
                        Path path = Path.of(pathString, new String[0]);
                        Optional entry = this.systemNode.locate(key);
                        this.logger.debug("{} {} {} -> {}", request.cmd(), entry.isPresent() ? "HIT" : "MISS", keyString, pathString);
                        if (entry.isPresent()) {
                            ((SystemEntry)entry.orElseThrow()).transferTo(path);
                            this.handle.writeResponse(Response.okData(request, Map.of()));
                            break;
                        }
                        this.handle.writeResponse(Response.koMessage(request, "Not found"));
                        break;
                    }
                    case "LS_CHECKSUMS": {
                        this.logger.debug("{} -> {}", (Object)request.cmd(), (Object)this.systemNode.checksumAlgorithms());
                        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                        this.systemNode.checksumAlgorithms().forEach(c -> data.put((String)c, (String)c));
                        this.handle.writeResponse(Response.okData(request, data));
                        break;
                    }
                    case "STORE_PATH": {
                        String keyString = request.requireData("keyString");
                        String pathString = request.requireData("pathString");
                        Map<String, String> data = request.data();
                        this.logger.debug("{} {} <- {}", request.cmd(), keyString, pathString);
                        URI key = URI.create(keyString);
                        this.handle.writeResponse(Response.okData(request, Utils.mergeEntry(this.systemNode.store(key, Path.of(pathString, new String[0]), Utils.splitMetadata(data), Utils.splitChecksums(data)))));
                        break;
                    }
                    default: {
                        this.handle.writeResponse(Response.koMessage(request, "Bad command"));
                    }
                }
            }
            catch (IOException e) {
                try {
                    this.handle.writeResponse(Response.koMessage(request, e.getMessage()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.logger.warn("Server error", e);
            }
        }
        catch (Exception e) {
            this.logger.warn("Server error", e);
        }
    }
}

