/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon.protocol;

import eu.maveniverse.maven.mimir.daemon.protocol.ImmutableRequest;
import eu.maveniverse.maven.mimir.daemon.protocol.ImmutableResponse;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import eu.maveniverse.maven.mimir.daemon.protocol.Response;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Handle
implements Closeable {
    public static final String DEFAULT_SOCKET_PATH = "mimir-socket";
    private final ByteChannel channel;
    private final DataOutputStream outputStream;
    private final DataInputStream inputStream;

    public static ServerHandle serverDomainSocket(final Path domainSocketPath) throws IOException {
        Objects.requireNonNull(domainSocketPath, "domainSocketPath");
        final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
        serverSocketChannel.configureBlocking(true);
        serverSocketChannel.bind(UnixDomainSocketAddress.of(domainSocketPath));
        return new ServerHandle(){
            private final AtomicBoolean closed = new AtomicBoolean(false);

            @Override
            public boolean isOpen() {
                return serverSocketChannel.isOpen();
            }

            @Override
            public Handle accept() throws IOException {
                return new Handle(serverSocketChannel.accept());
            }

            @Override
            public void close() throws IOException {
                if (this.closed.compareAndSet(false, true)) {
                    try {
                        serverSocketChannel.close();
                    }
                    finally {
                        Files.deleteIfExists(domainSocketPath);
                    }
                }
            }
        };
    }

    public static ClientHandle clientDomainSocket(final Path domainSocketPath) throws IOException {
        Objects.requireNonNull(domainSocketPath, "domainSocketPath");
        return new ClientHandle(){
            private final AtomicBoolean closed = new AtomicBoolean(false);

            @Override
            public boolean isOpen() {
                return !this.closed.get();
            }

            @Override
            public Handle getHandle() throws IOException {
                if (this.closed.get()) {
                    throw new IllegalStateException("ClientHandle has been closed");
                }
                SocketChannel socketChannel = SocketChannel.open(StandardProtocolFamily.UNIX);
                socketChannel.configureBlocking(true);
                socketChannel.connect(UnixDomainSocketAddress.of(domainSocketPath));
                return new Handle(socketChannel);
            }

            @Override
            public void close() {
                if (this.closed.compareAndSet(false, true)) {
                    // empty if block
                }
            }
        };
    }

    public static Handle byteChannel(ByteChannel byteChannel) {
        return new Handle(byteChannel);
    }

    private Handle(ByteChannel byteChannel) {
        this.channel = Objects.requireNonNull(byteChannel, "byteChannel");
        this.outputStream = new DataOutputStream(Channels.newOutputStream(this.channel));
        this.inputStream = new DataInputStream(Channels.newInputStream(this.channel));
    }

    public void writeRequest(Request request) throws IOException {
        Objects.requireNonNull(request, "request");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try (MessagePacker p = MessagePack.newDefaultPacker(b);){
            p.packString(request.cmd());
            this.packMap(p, request.data());
            this.packMap(p, request.session());
        }
        this.outputStream.writeInt(b.size());
        this.outputStream.write(b.toByteArray());
        this.outputStream.flush();
    }

    public Request readRequest() throws IOException {
        byte[] bytes = this.inputStream.readNBytes(this.inputStream.readInt());
        try (MessageUnpacker u = MessagePack.newDefaultUnpacker(bytes);){
            ImmutableRequest immutableRequest = ImmutableRequest.builder().cmd(u.unpackString()).data(this.unpackMap(u)).session(this.unpackMap(u)).build();
            return immutableRequest;
        }
    }

    public void writeResponse(Response response) throws IOException {
        Objects.requireNonNull(response, "response");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try (MessagePacker p = MessagePack.newDefaultPacker(b);){
            p.packString(response.status());
            this.packMap(p, response.data());
            this.packMap(p, response.session());
        }
        this.outputStream.writeInt(b.size());
        this.outputStream.write(b.toByteArray());
        this.outputStream.flush();
    }

    public Response readResponse() throws IOException {
        byte[] bytes = this.inputStream.readNBytes(this.inputStream.readInt());
        try (MessageUnpacker u = MessagePack.newDefaultUnpacker(bytes);){
            ImmutableResponse immutableResponse = ImmutableResponse.builder().status(u.unpackString()).data(this.unpackMap(u)).session(this.unpackMap(u)).build();
            return immutableResponse;
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private void packMap(MessagePacker p, Map<String, String> map) throws IOException {
        p.packMapHeader(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            p.packString(entry.getKey());
            p.packString(entry.getValue());
        }
    }

    private Map<String, String> unpackMap(MessageUnpacker u) throws IOException {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        int entries = u.unpackMapHeader();
        for (int i = 0; i < entries; ++i) {
            String key = u.unpackString();
            String value = u.unpackString();
            metadata.put(key, value);
        }
        return metadata;
    }

    public static interface ClientHandle
    extends Closeable {
        public boolean isOpen();

        public Handle getHandle() throws IOException;
    }

    public static interface ServerHandle
    extends Closeable {
        public boolean isOpen();

        public Handle accept() throws IOException;
    }
}

