/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.file;

import eu.maveniverse.maven.mimir.shared.impl.node.EntrySupport;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public final class FileEntry
extends EntrySupport
implements SystemEntry {
    private final Path path;
    private final boolean mayLink;

    public FileEntry(Map<String, String> metadata, Map<String, String> checksums, Path path, boolean mayLink) {
        super(metadata, checksums);
        this.path = Objects.requireNonNull(path, "path");
        this.mayLink = mayLink;
    }

    @Override
    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public void transferTo(Path file) throws IOException {
        Files.deleteIfExists(file);
        try (FileUtils.CollocatedTempFile f = FileUtils.newTempFile(file);){
            FileUtils.copyOrLink(this.path, f.getPath(), this.mayLink);
            f.move();
        }
    }
}

