/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.file;

import eu.maveniverse.maven.mimir.node.file.FileNode;
import eu.maveniverse.maven.mimir.node.file.FileNodeConfig;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.naming.KeyResolver;
import eu.maveniverse.maven.mimir.shared.naming.KeyResolverFactory;
import eu.maveniverse.maven.mimir.shared.node.SystemNodeFactory;
import eu.maveniverse.maven.shared.core.fs.DirectoryLocker;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

@Singleton
@Named(value="file")
public final class FileNodeFactory
implements SystemNodeFactory {
    private final Map<String, KeyResolverFactory> keyResolverFactories;
    private final Map<String, ChecksumAlgorithmFactory> checksumFactories;

    @Inject
    public FileNodeFactory(Map<String, KeyResolverFactory> keyResolverFactories, Map<String, ChecksumAlgorithmFactory> checksumFactories) {
        this.keyResolverFactories = Objects.requireNonNull(keyResolverFactories, "keyResolverFactories");
        this.checksumFactories = Objects.requireNonNull(checksumFactories, "checksumFactories");
    }

    @Override
    public FileNode createNode(SessionConfig sessionConfig) throws IOException {
        Objects.requireNonNull(sessionConfig, "config");
        FileNodeConfig fileNodeConfig = FileNodeConfig.with(sessionConfig);
        KeyResolverFactory keyResolverFactory = this.keyResolverFactories.get(fileNodeConfig.keyResolver());
        if (keyResolverFactory == null) {
            throw new IllegalArgumentException("Unknown keyResolver: " + fileNodeConfig.keyResolver());
        }
        KeyResolver keyResolver = Objects.requireNonNull(keyResolverFactory.createKeyResolver(sessionConfig), "keyResolver");
        for (String alg : fileNodeConfig.checksumAlgorithms()) {
            ChecksumAlgorithmFactory checksumAlgorithmFactory = this.checksumFactories.get(alg);
            if (checksumAlgorithmFactory != null) continue;
            throw new IllegalArgumentException("Unknown checksumAlgorithmFactory: " + alg);
        }
        return new FileNode(fileNodeConfig.basedir(), fileNodeConfig.mayLink(), fileNodeConfig.exclusiveAccess(), fileNodeConfig.cachePurge(), keyResolver, fileNodeConfig.checksumAlgorithms(), this.checksumFactories, DirectoryLocker.INSTANCE);
    }
}

