/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.jgroups;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Objects;

public class JGroupsNodeConfig {
    public static final String NAME = "jgroups";
    private final boolean enabled;
    private final boolean publisherEnabled;
    private final String publisherTransport;
    private final String jgroupsProps;
    private final String jgroupsNodeName;
    private final String jgroupsClusterName;
    private final String jgroupsInterface;

    public static JGroupsNodeConfig with(SessionConfig sessionConfig) throws IOException {
        Objects.requireNonNull(sessionConfig, "config");
        Object groupSuffix = "@n/a";
        if (!"unknown".equals(sessionConfig.mimirVersion())) {
            String version = sessionConfig.mimirVersion();
            groupSuffix = version.endsWith("-SNAPSHOT") ? "@" + version : "@" + version.substring(0, version.lastIndexOf(46));
        }
        boolean enabled = true;
        boolean publisherEnabled = true;
        String publisherTransport = "socket";
        String jgroupsProps = "udp-new.xml";
        String jgroupsNodeName = InetAddress.getLocalHost().getHostName();
        Object jgroupsClusterName = "mimir-jgroups" + (String)groupSuffix;
        String jgroupsInterface = null;
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.enabled")) {
            enabled = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.jgroups.enabled"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.publisher.enabled")) {
            publisherEnabled = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.jgroups.publisher.enabled"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.publisher.transport")) {
            publisherTransport = sessionConfig.effectiveProperties().get("mimir.jgroups.publisher.transport");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.props")) {
            jgroupsProps = sessionConfig.effectiveProperties().get("mimir.jgroups.props");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.nodeName")) {
            jgroupsNodeName = sessionConfig.effectiveProperties().get("mimir.jgroups.nodeName");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.clusterName")) {
            jgroupsClusterName = sessionConfig.effectiveProperties().get("mimir.jgroups.clusterName");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.jgroups.interface")) {
            jgroupsInterface = sessionConfig.effectiveProperties().get("mimir.jgroups.interface");
        }
        return new JGroupsNodeConfig(enabled, publisherEnabled, publisherTransport, jgroupsProps, jgroupsNodeName, (String)jgroupsClusterName, jgroupsInterface);
    }

    private JGroupsNodeConfig(boolean enabled, boolean publisherEnabled, String publisherTransport, String jgroupsProps, String jgroupsNodeName, String jgroupsClusterName, String jgroupsInterface) {
        this.enabled = enabled;
        this.publisherEnabled = publisherEnabled;
        this.publisherTransport = publisherTransport;
        this.jgroupsProps = jgroupsProps;
        this.jgroupsNodeName = jgroupsNodeName;
        this.jgroupsClusterName = jgroupsClusterName;
        this.jgroupsInterface = jgroupsInterface;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean publisherEnabled() {
        return this.publisherEnabled;
    }

    public String publisherTransport() {
        return this.publisherTransport;
    }

    public String jgroupsProps() {
        return this.jgroupsProps;
    }

    public String jgroupsNodeName() {
        return this.jgroupsNodeName;
    }

    public String jgroupsClusterName() {
        return this.jgroupsClusterName;
    }

    public String jgroupsInterface() {
        return this.jgroupsInterface;
    }
}

