/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared;

import eu.maveniverse.maven.mimir.shared.Session;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.aether.RepositorySystemSession;

public final class MimirUtils {
    private MimirUtils() {
    }

    public static Session lazyInit(RepositorySystemSession repositorySystemSession, Supplier<Session> sessionFactory) {
        Objects.requireNonNull(repositorySystemSession, "repositorySystemSession");
        Objects.requireNonNull(sessionFactory, "sessionFactory");
        Session session = (Session)repositorySystemSession.getData().get(Session.class);
        if (session == null) {
            session = sessionFactory.get();
            repositorySystemSession.getData().set(Session.class, session);
        }
        return session;
    }

    public static Optional<Session> mayGetSession(RepositorySystemSession repositorySystemSession) {
        Objects.requireNonNull(repositorySystemSession, "repositorySystemSession");
        return Optional.ofNullable((Session)repositorySystemSession.getData().get(Session.class));
    }
}

