/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared;

import eu.maveniverse.maven.shared.core.fs.FileUtils;
import eu.maveniverse.maven.shared.core.maven.MavenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.aether.RepositorySystemSession;

public interface SessionConfig {
    public static final String NAME = "mimir";
    public static final String UNKNOWN_VERSION = "unknown";
    public static final String CONF_PREFIX = "mimir.";
    public static final String CONF_ENABLED = "mimir.enabled";
    public static final String CONF_LOCAL_HOST_HINT = "mimir.localHostHint";
    public static final String CONF_IGNORE_ERROR_AT_SESSION_END = "mimir.ignoreErrorAtSessionEnd";

    public boolean enabled();

    public boolean ignoreErrorAtSessionEnd();

    public String mimirVersion();

    public Path basedir();

    public Path propertiesPath();

    public Map<String, String> userProperties();

    public Map<String, String> systemProperties();

    public Map<String, String> effectiveProperties();

    public Optional<String> localHostHint();

    public Optional<RepositorySystemSession> repositorySystemSession();

    default public Builder toBuilder() {
        return new Builder(this.enabled(), this.ignoreErrorAtSessionEnd(), this.mimirVersion(), this.basedir(), this.propertiesPath(), this.userProperties(), this.systemProperties(), this.repositorySystemSession().orElse(null));
    }

    public static Builder defaults() {
        return new Builder(null, null, MavenUtils.discoverArtifactVersion(SessionConfig.class.getClassLoader(), "eu.maveniverse.maven.mimir", "core", UNKNOWN_VERSION), null, null, Collections.emptyMap(), MavenUtils.toMap(System.getProperties()), null);
    }

    public static Builder daemonDefaults() {
        return SessionConfig.defaults().propertiesPath(Path.of("daemon.properties", new String[0]));
    }

    public static class Builder {
        private Boolean enabled;
        private Boolean ignoreErrorAtSessionEnd;
        private final String mimirVersion;
        private Path basedir;
        private Path propertiesPath;
        private Map<String, String> userProperties;
        private Map<String, String> systemProperties;
        private RepositorySystemSession repositorySystemSession;

        private Builder(Boolean enabled, Boolean ignoreErrorAtSessionEnd, String mimirVersion, Path basedir, Path propertiesPath, Map<String, String> userProperties, Map<String, String> systemProperties, RepositorySystemSession repositorySystemSession) {
            this.enabled = enabled;
            this.ignoreErrorAtSessionEnd = ignoreErrorAtSessionEnd;
            this.mimirVersion = Objects.requireNonNull(mimirVersion);
            this.basedir = basedir;
            this.propertiesPath = propertiesPath;
            this.userProperties = new HashMap<String, String>(userProperties);
            this.systemProperties = new HashMap<String, String>(systemProperties);
            this.repositorySystemSession = repositorySystemSession;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder ignoreErrorAtSessionEnd(boolean ignoreErrorAtSessionEnd) {
            this.ignoreErrorAtSessionEnd = ignoreErrorAtSessionEnd;
            return this;
        }

        public Builder basedir(Path basedir) {
            this.basedir = FileUtils.canonicalPath(basedir);
            return this;
        }

        public Builder propertiesPath(Path propertiesPath) {
            this.propertiesPath = Objects.requireNonNull(propertiesPath, "propertiesPath");
            return this;
        }

        public Builder userProperties(Map<String, String> userProperties) {
            Objects.requireNonNull(userProperties, "userProperties");
            this.userProperties = new HashMap<String, String>(userProperties);
            return this;
        }

        public Builder setUserProperty(String key, String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            this.userProperties.put(key, value);
            return this;
        }

        public Builder systemProperties(Map<String, String> systemProperties) {
            Objects.requireNonNull(systemProperties, "systemProperties");
            this.systemProperties = new HashMap<String, String>(systemProperties);
            return this;
        }

        public Builder setSystemProperty(String key, String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            this.systemProperties.put(key, value);
            return this;
        }

        public Builder repositorySystemSession(RepositorySystemSession repositorySystemSession) {
            this.repositorySystemSession = repositorySystemSession;
            return this;
        }

        public SessionConfig build() {
            return new Impl(this.enabled, this.ignoreErrorAtSessionEnd, this.mimirVersion, this.basedir, this.propertiesPath, this.userProperties, this.systemProperties, this.repositorySystemSession);
        }

        private static class Impl
        implements SessionConfig {
            private final boolean enabled;
            private final boolean ignoreErrorAtSessionEnd;
            private final String mimirVersion;
            private final Path basedir;
            private final Path propertiesPath;
            private final Map<String, String> userProperties;
            private final Map<String, String> systemProperties;
            private final Map<String, String> effectiveProperties;
            private final String localHostHint;
            private final RepositorySystemSession repositorySystemSession;

            private Impl(Boolean enabled, Boolean ignoreErrorAtSessionEnd, String mimirVersion, Path basedir, Path propertiesPath, Map<String, String> userProperties, Map<String, String> systemProperties, RepositorySystemSession repositorySystemSession) {
                this.mimirVersion = Objects.requireNonNull(mimirVersion, "mimirVersion");
                this.basedir = basedir == null ? FileUtils.discoverBaseDirectory("mimir.basedir", ".mimir") : FileUtils.canonicalPath(basedir);
                this.propertiesPath = propertiesPath == null ? this.basedir.resolve("mimir.properties") : FileUtils.canonicalPath(this.basedir.resolve(propertiesPath));
                Properties mimirProperties = new Properties();
                if (Files.isRegularFile(this.propertiesPath, new LinkOption[0])) {
                    try (InputStream inputStream2 = Files.newInputStream(this.propertiesPath, new OpenOption[0]);){
                        mimirProperties.load(inputStream2);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.userProperties = Map.copyOf(Objects.requireNonNull(userProperties, "userProperties"));
                this.systemProperties = Map.copyOf(Objects.requireNonNull(systemProperties, "systemProperties"));
                HashMap<String, String> eff = new HashMap<String, String>();
                eff.putAll(systemProperties);
                eff.putAll(MavenUtils.toMap(mimirProperties));
                eff.putAll(userProperties);
                this.effectiveProperties = Map.copyOf(eff);
                this.enabled = Boolean.parseBoolean(this.effectiveProperties.getOrDefault(SessionConfig.CONF_ENABLED, Boolean.TRUE.toString()));
                this.ignoreErrorAtSessionEnd = Boolean.parseBoolean(this.effectiveProperties.getOrDefault(SessionConfig.CONF_IGNORE_ERROR_AT_SESSION_END, Boolean.FALSE.toString()));
                this.localHostHint = this.effectiveProperties.get(SessionConfig.CONF_LOCAL_HOST_HINT);
                this.repositorySystemSession = repositorySystemSession;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public boolean ignoreErrorAtSessionEnd() {
                return this.ignoreErrorAtSessionEnd;
            }

            @Override
            public String mimirVersion() {
                return this.mimirVersion;
            }

            @Override
            public Path basedir() {
                return this.basedir;
            }

            @Override
            public Path propertiesPath() {
                return this.propertiesPath;
            }

            @Override
            public Map<String, String> userProperties() {
                return this.userProperties;
            }

            @Override
            public Map<String, String> systemProperties() {
                return this.systemProperties;
            }

            @Override
            public Map<String, String> effectiveProperties() {
                return this.effectiveProperties;
            }

            @Override
            public Optional<String> localHostHint() {
                return Optional.ofNullable(this.localHostHint);
            }

            @Override
            public Optional<RepositorySystemSession> repositorySystemSession() {
                return Optional.ofNullable(this.repositorySystemSession);
            }
        }
    }
}

