/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl;

import eu.maveniverse.maven.mimir.shared.Session;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.SessionFactory;
import eu.maveniverse.maven.mimir.shared.impl.SessionImpl;
import eu.maveniverse.maven.mimir.shared.impl.SessionImplConfig;
import eu.maveniverse.maven.mimir.shared.naming.KeyMapperFactory;
import eu.maveniverse.maven.mimir.shared.naming.RemoteRepositories;
import eu.maveniverse.maven.mimir.shared.node.LocalNode;
import eu.maveniverse.maven.mimir.shared.node.LocalNodeFactory;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.repository.RemoteRepository;

@Singleton
@Named
public final class SessionFactoryImpl
extends ComponentSupport
implements SessionFactory {
    private final Map<String, LocalNodeFactory> localNodeFactories;
    private final Map<String, KeyMapperFactory> nameMapperFactories;

    @Inject
    public SessionFactoryImpl(Map<String, LocalNodeFactory> localNodeFactories, Map<String, KeyMapperFactory> nameMapperFactories) {
        this.localNodeFactories = Objects.requireNonNull(localNodeFactories, "localNodeFactories");
        this.nameMapperFactories = Objects.requireNonNull(nameMapperFactories, "nameMapperFactories");
    }

    @Override
    public Session createSession(SessionConfig config) throws IOException {
        Objects.requireNonNull(config);
        SessionImplConfig cfg = SessionImplConfig.with(config);
        KeyMapperFactory keyMapperFactory = this.nameMapperFactories.get(cfg.keyMapper());
        if (keyMapperFactory == null) {
            throw new IllegalStateException("No keyMapper: " + cfg.keyMapper());
        }
        BiFunction keyMapper = Objects.requireNonNull(keyMapperFactory.createKeyMapper(config), "keyMapper");
        LocalNodeFactory localNodeFactory = this.localNodeFactories.get(cfg.localNode());
        if (localNodeFactory == null) {
            throw new IllegalArgumentException("Unknown local node: " + cfg.localNode());
        }
        LocalNode<?> localNode = localNodeFactory.createNode(config);
        Set<String> repositories = cfg.repositories();
        if (repositories.isEmpty()) {
            throw new IllegalStateException("No repositories to handle");
        }
        Predicate<RemoteRepository> repositoryPredicate = repositories.size() == 1 && repositories.contains("central") ? RemoteRepositories.centralDirectOnly() : RemoteRepositories.httpsReleaseDirectOnlyWithIds(repositories);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mimir {} session created", (Object)config.mimirVersion());
            this.logger.debug("  Enabled: {}", (Object)config.enabled());
            this.logger.debug("  Basedir: {}", (Object)config.basedir());
            this.logger.debug("  Properties: {}", (Object)config.basedir().resolve(config.propertiesPath()));
            this.logger.debug("  Key mapper: {}", (Object)keyMapper.getClass().getSimpleName());
            this.logger.debug("  Local Node: {}", (Object)localNode);
            this.logger.debug("  Repositories: {}", (Object)repositories);
            this.logger.debug("  Used checksums: {}", (Object)localNode.checksumAlgorithms());
            this.logger.debug("  Supported checksums: {}", (Object)localNode.checksumFactories().keySet());
        }
        return new SessionImpl(config, repositoryPredicate, a -> !a.isSnapshot(), keyMapper, localNode);
    }
}

