/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl;

import eu.maveniverse.maven.mimir.shared.Entry;
import eu.maveniverse.maven.mimir.shared.Session;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.impl.Stats;
import eu.maveniverse.maven.mimir.shared.node.LocalEntry;
import eu.maveniverse.maven.mimir.shared.node.LocalNode;
import eu.maveniverse.maven.shared.core.component.CloseableConfigSupport;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public final class SessionImpl
extends CloseableConfigSupport<SessionConfig>
implements Session {
    private final Predicate<RemoteRepository> repositoryPredicate;
    private final Predicate<Artifact> artifactPredicate;
    private final BiFunction<RemoteRepository, Artifact, URI> keyMapper;
    private final LocalNode<?> localNode;
    private final Stats stats;
    private final ConcurrentHashMap<RemoteRepository, Set<String>> retrievedFromCache;
    private final ConcurrentHashMap<RemoteRepository, Set<String>> storedToCache;

    public SessionImpl(SessionConfig sessionConfig, Predicate<RemoteRepository> repositoryPredicate, Predicate<Artifact> artifactPredicate, BiFunction<RemoteRepository, Artifact, URI> keyMapper, LocalNode<?> localNode) {
        super(sessionConfig);
        this.repositoryPredicate = Objects.requireNonNull(repositoryPredicate);
        this.artifactPredicate = Objects.requireNonNull(artifactPredicate);
        this.keyMapper = Objects.requireNonNull(keyMapper);
        this.localNode = Objects.requireNonNull(localNode);
        this.stats = new Stats();
        this.retrievedFromCache = new ConcurrentHashMap();
        this.storedToCache = new ConcurrentHashMap();
        this.logger.info("Mimir {} session created with {}", (Object)this.config().mimirVersion(), (Object)localNode);
    }

    @Override
    public SessionConfig config() {
        return (SessionConfig)this.config;
    }

    @Override
    public boolean repositorySupported(RemoteRepository repository) {
        this.checkClosed();
        return this.repositoryPredicate.test(repository);
    }

    @Override
    public boolean artifactSupported(Artifact artifact) {
        this.checkClosed();
        return this.artifactPredicate.test(artifact);
    }

    @Override
    public List<String> checksumAlgorithms() throws IOException {
        this.checkClosed();
        return this.localNode.checksumAlgorithms();
    }

    @Override
    public Optional<Entry> locate(final RemoteRepository remoteRepository, final Artifact artifact) throws IOException {
        URI key;
        Optional result;
        this.checkClosed();
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        Objects.requireNonNull(artifact, "artifact");
        if (this.repositoryPredicate.test(remoteRepository) && this.artifactPredicate.test(artifact) && (result = this.localNode.locate(key = this.keyMapper.apply(remoteRepository, artifact))).isPresent()) {
            final LocalEntry entry = (LocalEntry)result.orElseThrow();
            return this.stats.doLocate(Optional.of(new Entry(){

                @Override
                public void transferTo(Path file) throws IOException {
                    try {
                        entry.transferTo(file);
                        SessionImpl.this.stats.doTransfer(true);
                        SessionImpl.this.retrievedFromCache.computeIfAbsent(remoteRepository, k -> ConcurrentHashMap.newKeySet()).add(ArtifactIdUtils.toId(artifact));
                    }
                    catch (IOException e) {
                        SessionImpl.this.stats.doTransfer(false);
                        throw e;
                    }
                }

                @Override
                public Map<String, String> metadata() {
                    return entry.metadata();
                }

                @Override
                public Map<String, String> checksums() {
                    return entry.checksums();
                }
            }));
        }
        return this.stats.doLocate(Optional.empty());
    }

    @Override
    public void store(RemoteRepository remoteRepository, Artifact artifact, Path file, Map<String, String> metadata, Map<String, String> checksums) throws IOException {
        this.checkClosed();
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        Objects.requireNonNull(artifact, "artifact");
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(checksums, "checksums");
        if (this.repositoryPredicate.test(remoteRepository) && this.artifactPredicate.test(artifact)) {
            URI key = this.keyMapper.apply(remoteRepository, artifact);
            this.stats.doStore(Optional.of(this.localNode.store(key, file, metadata, checksums)));
            this.storedToCache.computeIfAbsent(remoteRepository, k -> ConcurrentHashMap.newKeySet()).add(ArtifactIdUtils.toId(artifact));
        } else {
            this.stats.doStore(Optional.empty());
        }
    }

    @Override
    public boolean retrievedFromCache(RemoteRepository remoteRepository, Artifact artifact) {
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        Objects.requireNonNull(artifact, "artifact");
        return this.retrievedFromCache.computeIfAbsent(remoteRepository, k -> ConcurrentHashMap.newKeySet()).contains(ArtifactIdUtils.toId(artifact));
    }

    @Override
    public boolean storedToCache(RemoteRepository remoteRepository, Artifact artifact) {
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        Objects.requireNonNull(artifact, "artifact");
        return this.storedToCache.computeIfAbsent(remoteRepository, k -> ConcurrentHashMap.newKeySet()).contains(ArtifactIdUtils.toId(artifact));
    }

    @Override
    protected void doClose() throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        try {
            this.localNode.close();
        }
        catch (IOException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            IOException closeException = new IOException("Could not close session");
            exceptions.forEach(closeException::addSuppressed);
            throw closeException;
        }
        this.logger.info("Mimir session closed (RETRIEVED={} CACHED={})", (Object)this.stats.transferSuccess(), (Object)this.stats.storeSuccess());
    }
}

