/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public final class SessionImplConfig {
    private final String keyMapper;
    private final String localNode;
    private final Set<String> repositories;

    public static SessionImplConfig with(SessionConfig sessionConfig) {
        Objects.requireNonNull(sessionConfig);
        String keyMapper = "simple";
        String localNode = "daemon";
        Set<String> repositories = Set.of("central");
        if (sessionConfig.effectiveProperties().containsKey("mimir.session.keyMapper")) {
            keyMapper = sessionConfig.effectiveProperties().get("mimir.session.keyMapper");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.session.localNode")) {
            localNode = sessionConfig.effectiveProperties().get("mimir.session.localNode");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.session.repositories")) {
            String value = sessionConfig.effectiveProperties().get("mimir.session.repositories");
            repositories = Set.copyOf(Arrays.asList(value.split(",")));
        }
        return new SessionImplConfig(keyMapper, localNode, repositories);
    }

    private SessionImplConfig(String keyMapper, String localNode, Set<String> repositories) {
        this.keyMapper = Objects.requireNonNull(keyMapper);
        this.localNode = Objects.requireNonNull(localNode);
        this.repositories = Objects.requireNonNull(repositories);
    }

    public String keyMapper() {
        return this.keyMapper;
    }

    public String localNode() {
        return this.localNode;
    }

    public Set<String> repositories() {
        return this.repositories;
    }
}

