/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl;

import eu.maveniverse.maven.mimir.shared.node.Entry;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public final class Utils {
    private static final String METADATA_PREFIX = "m.";
    private static final String CHECKSUM_PREFIX = "c.";

    private Utils() {
    }

    public static Map<String, String> mergeEntry(Entry entry) {
        return Utils.mergeEntry(entry.metadata(), entry.checksums());
    }

    public static Map<String, String> mergeEntry(Map<String, String> metadata, Map<String, String> checksums) {
        HashMap<String, String> merged = new HashMap<String, String>();
        metadata.forEach((k, v) -> merged.put(METADATA_PREFIX + k, (String)v));
        checksums.forEach((k, v) -> merged.put(CHECKSUM_PREFIX + k, (String)v));
        return merged;
    }

    private static Map<String, String> split(Map<String, String> merged, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        merged.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).forEach(e -> result.put(((String)e.getKey()).substring(prefix.length()), (String)e.getValue()));
        return result;
    }

    public static Map<String, String> splitMetadata(Map<String, String> merged) {
        return Utils.split(merged, METADATA_PREFIX);
    }

    public static Map<String, String> splitChecksums(Map<String, String> merged) {
        return Utils.split(merged, CHECKSUM_PREFIX);
    }

    public static InetAddress getLocalHost(String hint) throws UnknownHostException {
        Predicate<NetworkInterface> interfacePredicate = Utils.interfaceMatcher(hint);
        Predicate<InetAddress> addressPredicate = Utils.addressMatcher(hint);
        if (hint != null && interfacePredicate == null && addressPredicate == null) {
            throw new IllegalArgumentException("Invalid hint " + hint);
        }
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp() || interfacePredicate != null && !interfacePredicate.test(iface)) continue;
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (addressPredicate != null && !addressPredicate.test(inetAddr) || inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e.getMessage());
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    private static Predicate<NetworkInterface> interfaceMatcher(String hint) {
        if (hint == null || !hint.startsWith("match-interface:")) {
            return null;
        }
        String name = hint.substring("match-interface:".length());
        if (name.contains("*") && !name.endsWith("*")) {
            throw new IllegalArgumentException("Invalid match-interface: " + hint);
        }
        if (name.endsWith("*")) {
            String fname = name.substring(0, name.length() - 1);
            return iface -> iface.getName().startsWith(fname);
        }
        return iface -> iface.getName().equals(name);
    }

    private static Predicate<InetAddress> addressMatcher(String hint) {
        if (hint == null || !hint.startsWith("match-address:")) {
            return null;
        }
        String name = hint.substring("match-address:".length());
        if (name.contains("*") && !name.endsWith("*")) {
            throw new IllegalArgumentException("Invalid match-address: " + hint);
        }
        if (name.endsWith("*")) {
            String fname = name.substring(0, name.length() - 1);
            return addr -> addr.getHostAddress().startsWith(fname);
        }
        return addr -> addr.getHostAddress().equals(name);
    }
}

