/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.naming;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.naming.KeyMapper;
import eu.maveniverse.maven.mimir.shared.naming.KeyMapperFactory;
import eu.maveniverse.maven.mimir.shared.naming.RemoteRepositories;
import java.net.URI;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.StringDigestUtil;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Singleton
@Named(value="simple")
public final class SimpleKeyMapperFactory
implements KeyMapperFactory {
    public static final String NAME = "simple";

    @Override
    public KeyMapper createKeyMapper(SessionConfig sessionConfig) {
        Objects.requireNonNull(sessionConfig);
        return new SimpleKeyMapper();
    }

    public static class SimpleKeyMapper
    implements KeyMapper {
        private static final Predicate<RemoteRepository> CENTRAL_PREDICATE = RemoteRepositories.centralDirectOnly();

        public String container(RemoteRepository repository) {
            if (CENTRAL_PREDICATE.test(repository)) {
                return repository.getId();
            }
            return repository.getId() + "-" + StringDigestUtil.sha1(repository.getUrl());
        }

        public String name(Artifact artifact) {
            return ArtifactIdUtils.toId(artifact);
        }

        @Override
        public URI apply(RemoteRepository remoteRepository, Artifact artifact) {
            return URI.create("mimir:artifact:" + this.container(remoteRepository) + ":" + this.name(artifact));
        }
    }
}

