/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.naming;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.naming.Key;
import eu.maveniverse.maven.mimir.shared.naming.KeyResolver;
import eu.maveniverse.maven.mimir.shared.naming.KeyResolverFactory;
import java.net.URI;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Singleton
@Named(value="simple")
public final class SimpleKeyResolverFactory
implements KeyResolverFactory {
    public static final String NAME = "simple";

    @Override
    public KeyResolver createKeyResolver(SessionConfig sessionConfig) {
        Objects.requireNonNull(sessionConfig);
        return new SimpleKeyResolver();
    }

    public static class SimpleKeyResolver
    implements KeyResolver {
        public String artifactPath(Artifact artifact) {
            String name = artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getBaseVersion() + "/" + artifact.getArtifactId() + "-" + artifact.getVersion();
            if (artifact.getClassifier() != null && !artifact.getClassifier().trim().isEmpty()) {
                name = name + "-" + artifact.getClassifier();
            }
            name = name + "." + artifact.getExtension();
            return name;
        }

        @Override
        public Key apply(URI key) {
            if (key.isOpaque() && "mimir".equals(key.getScheme())) {
                String[] bits;
                String ssp = key.getSchemeSpecificPart();
                if (ssp.startsWith("artifact:")) {
                    String[] bits2 = ssp.substring(9).split(":", 2);
                    if (bits2.length == 2) {
                        String container = bits2[0];
                        DefaultArtifact artifact = new DefaultArtifact(bits2[1]);
                        return Key.of(container, this.artifactPath(artifact));
                    }
                } else if (ssp.startsWith("file:") && (bits = ssp.substring(5).split(":", 2)).length == 2) {
                    String container = bits[0];
                    String path = bits[1];
                    return Key.of(container, path);
                }
            }
            throw new IllegalArgumentException("Unexpected URI");
        }
    }
}

