/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.publisher;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.impl.Utils;
import java.io.IOException;
import java.util.Objects;

public class PublisherConfig {
    private final String hostAddress;
    private final int hostPort;

    public static PublisherConfig with(SessionConfig sessionConfig) throws IOException {
        Objects.requireNonNull(sessionConfig);
        String hostAddress = Utils.getLocalHost(sessionConfig.localHostHint().orElse(null)).getHostAddress();
        int hostPort = 0;
        if (sessionConfig.effectiveProperties().containsKey("mimir.publisher.hostAddress")) {
            hostAddress = sessionConfig.effectiveProperties().get("mimir.publisher.hostAddress");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.publisher.hostPort")) {
            hostPort = Integer.parseInt(sessionConfig.effectiveProperties().get("mimir.publisher.hostPort"));
        }
        return new PublisherConfig(hostAddress, hostPort);
    }

    private PublisherConfig(String hostAddress, int hostPort) {
        this.hostAddress = Objects.requireNonNull(hostAddress);
        this.hostPort = hostPort;
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public int hostPort() {
        return this.hostPort;
    }
}

