/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.publisher;

import eu.maveniverse.maven.mimir.shared.impl.node.EntrySupport;
import eu.maveniverse.maven.mimir.shared.node.RemoteEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class PublisherRemoteEntry
extends EntrySupport
implements RemoteEntry {
    private final URI handle;

    public PublisherRemoteEntry(Map<String, String> metadata, Map<String, String> checksums, URI handle) {
        super(metadata, checksums);
        this.handle = Objects.requireNonNull(handle);
    }

    @Override
    public void handleContent(RemoteEntry.IOConsumer consumer) throws IOException {
        block15: {
            String schema = this.handle.getScheme();
            try {
                if ("http".equals(schema)) {
                    try (InputStream inputStream2 = this.handle.toURL().openConnection().getInputStream();){
                        consumer.accept(inputStream2);
                        break block15;
                    }
                }
                if ("socket".equals(schema)) {
                    try (Socket socket = new Socket(this.handle.getHost(), this.handle.getPort());){
                        OutputStream os = socket.getOutputStream();
                        os.write(this.handle.getPath().substring(1).getBytes(StandardCharsets.UTF_8));
                        os.flush();
                        consumer.accept(socket.getInputStream());
                        break block15;
                    }
                }
                throw new IOException("Unknown protocol: " + schema);
            }
            catch (IOException e) {
                throw new IOException("Failed to get artifact content from publisher at " + this.handle.toASCIIString(), e);
            }
        }
    }
}

