/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.publisher;

import eu.maveniverse.maven.mimir.shared.impl.publisher.PublisherConfig;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import eu.maveniverse.maven.mimir.shared.publisher.Publisher;
import eu.maveniverse.maven.shared.core.component.CloseableSupport;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class PublisherSupport
extends CloseableSupport
implements Publisher {
    protected final SystemNode<?> systemNode;
    protected final PublisherConfig publisherConfig;
    protected final ConcurrentMap<String, SystemEntry> publishedEntries;

    protected PublisherSupport(SystemNode<?> systemNode, PublisherConfig publisherConfig) {
        this.systemNode = Objects.requireNonNull(systemNode);
        this.publisherConfig = Objects.requireNonNull(publisherConfig);
        this.publishedEntries = new ConcurrentHashMap<String, SystemEntry>();
    }

    @Override
    public Optional<Publisher.Handle> createHandle(URI key) throws IOException {
        Optional entry = this.systemNode.locate(key);
        if (entry.isPresent()) {
            String token = UUID.randomUUID().toString();
            URI publishHandle = this.createHandle(token);
            SystemEntry systemEntry = (SystemEntry)entry.orElseThrow();
            this.publishedEntries.put(token, systemEntry);
            return Optional.of(new HandleImpl(publishHandle, systemEntry));
        }
        return Optional.empty();
    }

    protected Optional<SystemEntry> publishedEntry(String token) {
        return Optional.ofNullable((SystemEntry)this.publishedEntries.remove(token));
    }

    protected abstract URI createHandle(String var1) throws IOException;

    protected static final class HandleImpl
    implements Publisher.Handle {
        private final URI handle;
        private final SystemEntry systemEntry;

        public HandleImpl(URI handle, SystemEntry systemEntry) {
            this.handle = Objects.requireNonNull(handle);
            this.systemEntry = Objects.requireNonNull(systemEntry);
        }

        @Override
        public URI handle() {
            return this.handle;
        }

        @Override
        public SystemEntry publishedEntry() {
            return this.systemEntry;
        }
    }
}

