/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.naming;

import java.util.Objects;

public interface Key {
    public String container();

    public String name();

    public static Key of(String container, String name) {
        Objects.requireNonNull(container, "container");
        Objects.requireNonNull(name, "name");
        return new Impl(container, name);
    }

    public static class Impl
    implements Key {
        private final String container;
        private final String name;

        private Impl(String container, String name) {
            this.container = container;
            this.name = name;
        }

        @Override
        public String container() {
            return this.container;
        }

        @Override
        public String name() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Impl impl = (Impl)o;
            return Objects.equals(this.container, impl.container) && Objects.equals(this.name, impl.name);
        }

        public int hashCode() {
            return Objects.hash(this.container, this.name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{container='" + this.container + "', name='" + this.name + "'}";
        }
    }
}

