/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.node;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public interface Entry {
    public static final String CONTENT_PREFIX = "content-";
    public static final String CONTENT_LENGTH = "content-length";
    public static final String CONTENT_LAST_MODIFIED = "content-modified";

    public Map<String, String> metadata();

    public Map<String, String> checksums();

    default public long getContentLength() {
        return Long.parseLong(Objects.requireNonNull(this.metadata().get(CONTENT_LENGTH), CONTENT_LENGTH));
    }

    public static void setContentLength(Map<String, String> metadata, long contentLength) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length cannot be negative");
        }
        metadata.put(CONTENT_LENGTH, Long.toString(contentLength));
    }

    default public Instant getContentLastModified() {
        return Instant.ofEpochMilli(Long.parseLong(Objects.requireNonNull(this.metadata().get(CONTENT_LAST_MODIFIED), CONTENT_LAST_MODIFIED)));
    }

    public static void setContentLastModified(Map<String, String> metadata, Instant contentLastModified) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        Objects.requireNonNull(contentLastModified, "Content last modified cannot be null");
        metadata.put(CONTENT_LAST_MODIFIED, Long.toString(contentLastModified.toEpochMilli()));
    }
}

