/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class JDBC_PING
extends FILE_PING {
    @Property(description="The JDBC connection URL", writable=false)
    protected String connection_url;
    @Property(description="The JDBC connection username", writable=false)
    protected String connection_username;
    @Property(description="The JDBC connection password", writable=false, exposeAsManagedAttribute=false)
    protected String connection_password;
    @Property(description="The JDBC connection driver name", writable=false)
    protected String connection_driver;
    @Property(description="If not empty, this SQL statement will be performed at startup.Customize it to create the needed table on those databases which permit table creation attempt without losing data, such as PostgreSQL and MySQL (using IF NOT EXISTS). To allow for creation attempts, errors performing this statement will be loggedbut not considered fatal. To avoid any DDL operation, set this to an empty string.")
    protected String initialize_sql = "CREATE TABLE JGROUPSPING (own_addr varchar(200) NOT NULL, cluster_name varchar(200) NOT NULL, ping_data varbinary(5000) DEFAULT NULL, PRIMARY KEY (own_addr, cluster_name) )";
    @Property(description="SQL used to insert a new row. Customizable, but keep the order of parameters and pick compatible types: 1)Own Address, as String 2)Cluster name, as String 3)Serialized PingData as byte[]")
    protected String insert_single_sql = "INSERT INTO JGROUPSPING (own_addr, cluster_name, ping_data) values (?, ?, ?)";
    @Property(description="SQL used to delete a row. Customizable, but keep the order of parameters and pick compatible types: 1)Own Address, as String 2)Cluster name, as String")
    protected String delete_single_sql = "DELETE FROM JGROUPSPING WHERE own_addr=? AND cluster_name=?";
    @Property(description="SQL to clear the table")
    protected String clear_sql = "DELETE from JGROUPSPING WHERE cluster_name=?";
    @Property(description="SQL used to fetch all node's PingData. Customizable, but keep the order of parameters and pick compatible types: only one parameter needed, String compatible, representing the Cluster name. Must return a byte[], the Serialized PingData as it was stored by the insert_single_sql statement. Must select primary keys subsequently for cleanup to work properly")
    protected String select_all_pingdata_sql = "SELECT ping_data, own_addr, cluster_name FROM JGROUPSPING WHERE cluster_name=?";
    @Property(description="Finds a given entry by its address and cluster name, used to implement a contains()")
    protected String contains_sql = "SELECT count(own_addr) as RECORDCOUNT from JGROUPSPING WHERE cluster_name=? AND own_addr=?";
    @Property(description="To use a DataSource registered in JNDI, specify the JNDI name here. This is an alternative to all connection_* configuration options: if this property is not empty, then all connection relatedproperties must be empty.")
    protected String datasource_jndi_name;
    @Property(description="The fully qualified name of a class which implements a Function<JDBC_PING,DataSource>. If not null, this has precedence over datasource_jndi_name.")
    protected String datasource_injecter_class;
    protected DataSource dataSource;

    @Override
    protected void createRootDir() {
    }

    public JDBC_PING setDataSource(DataSource ds) {
        this.dataSource = ds;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getConnectionUrl() {
        return this.connection_url;
    }

    public JDBC_PING setConnectionUrl(String c) {
        this.connection_url = c;
        return this;
    }

    public String getConnectionUsername() {
        return this.connection_username;
    }

    public JDBC_PING setConnectionUsername(String c) {
        this.connection_username = c;
        return this;
    }

    public String getConnectionPassword() {
        return this.connection_password;
    }

    public JDBC_PING setConnectionPassword(String c) {
        this.connection_password = c;
        return this;
    }

    public String getConnectionDriver() {
        return this.connection_driver;
    }

    public JDBC_PING setConnectionDriver(String c) {
        this.connection_driver = c;
        return this;
    }

    public String getInitializeSql() {
        return this.initialize_sql;
    }

    public JDBC_PING setInitializeSql(String i) {
        this.initialize_sql = i;
        return this;
    }

    public String getInsertSingleSql() {
        return this.insert_single_sql;
    }

    public JDBC_PING setInsertSingleSql(String i) {
        this.insert_single_sql = i;
        return this;
    }

    public String getDeleteSingleSql() {
        return this.delete_single_sql;
    }

    public JDBC_PING setDeleteSingleSql(String d) {
        this.delete_single_sql = d;
        return this;
    }

    public String getClearSql() {
        return this.clear_sql;
    }

    public JDBC_PING setClearSql(String c) {
        this.clear_sql = c;
        return this;
    }

    public String getSelectAllPingdataSql() {
        return this.select_all_pingdata_sql;
    }

    public JDBC_PING setSelectAllPingdataSql(String s) {
        this.select_all_pingdata_sql = s;
        return this;
    }

    public String getContainsSql() {
        return this.contains_sql;
    }

    public JDBC_PING setContainsSql(String c) {
        this.contains_sql = c;
        return this;
    }

    public String getDatasourceJndiName() {
        return this.datasource_jndi_name;
    }

    public JDBC_PING setDatasourceJndiName(String d) {
        this.datasource_jndi_name = d;
        return this;
    }

    public String getDatasourceInjecterClass() {
        return this.datasource_injecter_class;
    }

    public JDBC_PING setDatasourceInjecterClass(String d) {
        this.datasource_injecter_class = d;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.verifyConfigurationParameters();
        if (this.dataSource == null) {
            if (this.datasource_injecter_class != null) {
                this.dataSource = this.injectDataSource(this.datasource_injecter_class);
                if (this.dataSource == null) {
                    String m = String.format("datasource_injecter_class %s created null datasource", this.datasource_injecter_class);
                    throw new IllegalArgumentException(m);
                }
            } else if (this.datasource_jndi_name != null) {
                this.dataSource = this.getDataSourceFromJNDI(this.datasource_jndi_name.trim());
            } else {
                this.loadDriver();
            }
        }
        this.attemptSchemaInitialization();
    }

    @Override
    protected void write(List<PingData> list, String clustername) {
        for (PingData data : list) {
            this.writeToDB(data, clustername, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeToDB(PingData data, String clustername, boolean overwrite) {
        String ownAddress = JDBC_PING.addressAsString(data.getAddress());
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                if (overwrite) {
                    this.delete(connection, clustername, ownAddress);
                } else if (this.contains(clustername, data.getAddress())) {
                    return;
                }
                this.insert(connection, data, clustername, ownAddress);
            }
            catch (SQLException e) {
                this.log.error(Util.getMessage("ErrorUpdatingJDBCPINGTable"), e);
            }
            finally {
                this.closeConnection(connection);
            }
        } else {
            this.log.error(Util.getMessage("FailedToStorePingDataInDatabase"));
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean contains(String cluster_name, Address addr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void remove(String clustername, Address addr) {
        String addressAsString = JDBC_PING.addressAsString(addr);
        try {
            this.delete(clustername, addressAsString);
        }
        catch (SQLException e) {
            this.log.error("Error", e);
        }
    }

    @Override
    protected void removeAll(String clustername) {
        this.clearTable(clustername);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readAll(List<Address> members, String clustername, Responses responses) {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.readAll(connection, members, clustername, responses);
            }
            catch (SQLException e) {
                this.log.error(Util.getMessage("ErrorReadingJDBCPINGTable"), e);
            }
            finally {
                this.closeConnection(connection);
            }
        }
    }

    protected static final PreparedStatement prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException x) {
            try {
                return connection.prepareStatement(sql);
            }
            catch (SQLException x2) {
                x.addSuppressed(x2);
                throw x;
            }
        }
    }

    protected void readAll(Connection connection, List<Address> members, String clustername, Responses rsps) throws SQLException {
        block20: {
            try (PreparedStatement ps = JDBC_PING.prepareStatement(connection, this.select_all_pingdata_sql, 1003, 1008);){
                ps.setString(1, clustername);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: SQL for reading: %s", this.local_addr, ps);
                }
                ResultSet resultSet = ps.executeQuery();
                block14: while (true) {
                    while (resultSet.next()) {
                        byte[] bytes = resultSet.getBytes(1);
                        try {
                            List<PingData> list = this.readPingData(bytes, 0, bytes.length);
                            if (list == null) continue block14;
                            Iterator<PingData> iterator2 = list.iterator();
                            while (true) {
                                if (!iterator2.hasNext()) continue block14;
                                PingData data = iterator2.next();
                                ++this.reads;
                                if (data == null || members != null && !members.contains(data.getAddress())) continue;
                                rsps.addResponse(data, false);
                                if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                                this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                            }
                        }
                        catch (Exception e) {
                            int row = resultSet.getRow();
                            this.log.error("%s: failed deserializing row %d: %s; removing it from the table", this.local_addr, row, e);
                            try {
                                resultSet.deleteRow();
                                continue block14;
                            }
                            catch (Throwable t) {
                                this.log.error("%s: failed removing row %d: %s; please delete it manually", this.local_addr, row, e);
                            }
                        }
                    }
                    break block20;
                    {
                        continue block14;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSchemaInitialization() {
        if (this.initialize_sql == null) {
            this.log.debug("Table creation step skipped: initialize_sql attribute is missing");
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(this.initialize_sql);){
            if (this.log.isTraceEnabled()) {
                this.log.trace("SQL for initializing schema: %s", ps);
            }
            ps.execute();
            this.log.debug("Table created for JDBC_PING Discovery Protocol");
        }
        catch (SQLException e) {
            this.log.debug("Could not execute initialize_sql statement; not necessarily an error, we always attempt to create the schema. To suppress this message, set initialize_sql to an empty value. Cause: %s", e.getMessage());
        }
        finally {
            this.closeConnection(connection);
        }
    }

    protected void loadDriver() {
        JDBC_PING.assertNonNull("connection_driver", this.connection_driver);
        this.log.debug("Registering JDBC driver %s", this.connection_driver);
        try {
            Util.loadClass(this.connection_driver, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("JDBC driver could not be loaded: '%s'", this.connection_driver));
        }
    }

    protected DataSource injectDataSource(String ds_class) throws Exception {
        Class<?> cl = Util.loadClass(ds_class, Thread.currentThread().getContextClassLoader());
        Object obj = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        Function fun = (Function)obj;
        return (DataSource)fun.apply(this);
    }

    protected Connection getConnection() {
        if (this.dataSource == null) {
            Connection connection;
            try {
                connection = DriverManager.getConnection(this.connection_url, this.connection_username, this.connection_password);
            }
            catch (SQLException e) {
                this.log.error(Util.getMessage("CouldNotOpenConnectionToDatabase"), e);
                return null;
            }
            if (connection == null) {
                this.log.error(Util.getMessage("ReceivedNullConnectionFromTheDriverManager"));
            }
            return connection;
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.log.error(Util.getMessage("CouldNotOpenConnectionToDatabase"), e);
            return null;
        }
    }

    protected synchronized void insert(Connection connection, PingData data, String clustername, String address) throws SQLException {
        ByteArray serializedPingData = this.serializeWithoutView(data);
        try (PreparedStatement ps = connection.prepareStatement(this.insert_single_sql);){
            ps.setString(1, address);
            ps.setString(2, clustername);
            ps.setBytes(3, serializedPingData.getBytes());
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: SQL for insertion: %s", this.local_addr, ps);
            }
            ps.executeUpdate();
            this.log.debug("Inserted %s for cluster %s into database", address, clustername);
        }
    }

    protected synchronized void delete(Connection connection, String clustername, String addressToDelete) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement(this.delete_single_sql);){
            ps.setString(1, addressToDelete);
            ps.setString(2, clustername);
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: SQL for deletion: %s", this.local_addr, ps);
            }
            ps.executeUpdate();
            this.log.debug("Removed %s for cluster %s from database", addressToDelete, clustername);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(String clustername, String addressToDelete) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.delete(connection, clustername, addressToDelete);
            }
            catch (SQLException e) {
                this.log.error(Util.getMessage("ErrorUpdatingJDBCPINGTable"), e);
            }
            finally {
                this.closeConnection(connection);
            }
        } else {
            this.log.error(Util.getMessage("FailedToDeletePingDataInDatabase"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTable(String clustername) {
        block22: {
            try (Connection conn = this.getConnection();){
                if (conn == null) break block22;
                try (PreparedStatement ps = conn.prepareStatement(this.clear_sql);){
                    if (this.clear_sql.indexOf(63) >= 0) {
                        ps.setString(1, clustername);
                    } else {
                        this.log.debug("Please update your clear_sql to include cluster_name parameter.");
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("%s: SQL for clearing the table: %s", this.local_addr, ps);
                    }
                    ps.execute();
                    this.log.debug("%s: cleared table for cluster %s", this.local_addr, clustername);
                }
                catch (SQLException e1) {
                    this.log.error(Util.getMessage("ErrorClearingTable"), e1);
                }
                finally {
                    this.closeConnection(conn);
                }
            }
            catch (SQLException e2) {
                this.log.error(Util.getMessage("ErrorClearingTable"), e2);
            }
        }
    }

    protected void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            this.log.error(Util.getMessage("ErrorClosingConnectionToJDBCPINGDatabase"), e);
        }
    }

    protected DataSource getDataSourceFromJNDI(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object whatever = ctx.lookup(name);
            if (whatever == null) {
                throw new IllegalArgumentException("JNDI name " + name + " is not bound");
            }
            if (!(whatever instanceof DataSource)) {
                throw new IllegalArgumentException("JNDI name " + name + " was found but is not a DataSource");
            }
            DataSource data_source = (DataSource)whatever;
            this.log.debug("Datasource found via JNDI lookup via name: %s", name);
            DataSource dataSource = data_source;
            return dataSource;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Could not lookup datasource " + name, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    this.log.warn("Failed to close naming context.", e);
                }
            }
        }
    }

    protected void verifyConfigurationParameters() {
        JDBC_PING.assertNonNull("insert_single_sql", this.insert_single_sql, "clear_sql", this.clear_sql, "delete_single_sql", this.delete_single_sql, "select_all_pingdata_sql", this.select_all_pingdata_sql, "contains_sql", this.contains_sql);
    }

    protected static void assertNonNull(String ... strings) {
        for (int i = 0; i < strings.length; i += 2) {
            String attr = strings[i];
            String val = strings[i + 1];
            if (val != null) continue;
            throw new IllegalArgumentException(String.format("%s must not be null", attr));
        }
    }

    public static void main(String[] args2) throws ClassNotFoundException {
        String driver = "org.hsqldb.jdbcDriver";
        String user = "SA";
        String pwd2 = "";
        String conn = "jdbc:hsqldb:hsql://localhost/";
        String cluster = "draw";
        String select = "SELECT ping_data, own_addr, cluster_name FROM JGROUPSPING WHERE cluster_name=?";
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-driver")) {
                driver = args2[++i];
                continue;
            }
            if (args2[i].equals("-conn")) {
                conn = args2[++i];
                continue;
            }
            if (args2[i].equals("-user")) {
                user = args2[++i];
                continue;
            }
            if (args2[i].equals("-pwd")) {
                pwd2 = args2[++i];
                continue;
            }
            if (args2[i].equals("-cluster")) {
                cluster = args2[++i];
                continue;
            }
            if (args2[i].equals("-select")) {
                select = args2[++i];
                continue;
            }
            System.out.println("JDBC_PING [-driver driver] [-conn conn-url] [-user user] [-pwd password] [-cluster cluster-name] [-select select-stmt]");
            return;
        }
        Class.forName(driver);
        try (Connection c = DriverManager.getConnection(conn, user, pwd2);
             PreparedStatement ps = JDBC_PING.prepareStatement(c, select, 1003, 1008);){
            ps.setString(1, cluster);
            try (ResultSet resultSet = ps.executeQuery();){
                int index = 1;
                while (resultSet.next()) {
                    byte[] bytes = resultSet.getBytes(1);
                    try {
                        List<PingData> list = JDBC_PING.deserialize(bytes, 0, bytes.length);
                        if (list == null) continue;
                        for (PingData data : list) {
                            System.out.printf("%d %s\n", index++, data);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

