/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Lifecycle;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.jmx.ReflectUtils;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Policy;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolHook;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Ref;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public class ProtocolStack
extends Protocol {
    protected static final String max_list_print_size = "max-list-print-size";
    protected Protocol top_prot;
    protected Protocol bottom_prot;
    protected JChannel channel;
    protected volatile boolean stopped = true;
    protected final DiagnosticsHandler.ProbeHandler props_handler = new DiagnosticsHandler.ProbeHandler(){

        @Override
        public Map<String, String> handleProbe(String ... keys2) {
            for (String key : keys2) {
                List<String> prots;
                String rest;
                int len;
                int index;
                int index2;
                if (Objects.equals(key, "props")) {
                    String tmp = ProtocolStack.this.printProtocolSpec(true);
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put("props", tmp);
                    return map;
                }
                if (key.startsWith(ProtocolStack.max_list_print_size)) {
                    index2 = key.indexOf(61);
                    if (index2 >= 0) {
                        Util.MAX_LIST_PRINT_SIZE = Integer.parseInt(key.substring(index2 + 1));
                    }
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put(ProtocolStack.max_list_print_size, String.valueOf(Util.MAX_LIST_PRINT_SIZE));
                    return map;
                }
                if (key.equals("pp") || key.startsWith("print-protocols")) {
                    List<Protocol> prots2 = ProtocolStack.this.getProtocols();
                    Collections.reverse(prots2);
                    StringBuilder sb = new StringBuilder();
                    for (Protocol prot : prots2) {
                        sb.append(prot.getName()).append("\n");
                    }
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put("protocols", sb.toString());
                    return map;
                }
                if ((key.startsWith("rp") || key.startsWith("remove-protocol")) && (index = (key = key.substring(len = key.startsWith("rp") ? "rp".length() : "remove-protocol".length())).indexOf(61)) != -1 && (rest = key.substring(index + 1)) != null && !rest.isEmpty() && !(prots = Util.parseCommaDelimitedStrings(rest)).isEmpty()) {
                    for (String p : prots) {
                        List protocols = ProtocolStack.this.findProtocols(p);
                        if (protocols == null || protocols.isEmpty()) continue;
                        for (Protocol prot_to_remove : protocols) {
                            try {
                                Protocol removed = ProtocolStack.this.removeProtocol(prot_to_remove);
                                if (removed == null) continue;
                                ProtocolStack.this.log.debug("removed protocol %s from stack", prot_to_remove.getName());
                            }
                            catch (Exception e) {
                                ProtocolStack.this.log.error(Util.getMessage("FailedRemovingProtocol") + rest, e);
                            }
                        }
                    }
                }
                if (!key.startsWith("insert-protocol")) continue;
                index2 = (key = key.substring("insert-protocol".length() + 1)).indexOf(61);
                if (index2 == -1) break;
                String prot_name = key.substring(0, index2).trim();
                if (ProtocolStack.this.findProtocol(prot_name) != null) {
                    ProtocolStack.this.log.error("Protocol %s cannot be inserted as it is already present", prot_name);
                    break;
                }
                Protocol prot = null;
                try {
                    prot = ProtocolStack.this.createProtocol(prot_name);
                }
                catch (Exception e) {
                    ProtocolStack.this.log.error(Util.getMessage("FailedCreatingAnInstanceOf") + prot_name, e);
                    break;
                }
                key = key.substring(index2 + 1);
                index2 = key.indexOf(61);
                if (index2 == -1) {
                    ProtocolStack.this.log.error("= missing in insert-protocol command");
                    break;
                }
                String tmp = key.substring(0, index2);
                if (!tmp.equalsIgnoreCase("above") && !tmp.equalsIgnoreCase("below")) {
                    ProtocolStack.this.log.error("Missing \"above\" or \"below\" in insert-protocol command");
                    break;
                }
                String neighbor_prot = (key = key.substring(index2 + 1)).trim();
                Object neighbor = ProtocolStack.this.findProtocol(neighbor_prot);
                if (neighbor == null) {
                    ProtocolStack.this.log.error(Util.getMessage("NeighborProtocol") + " " + neighbor_prot + " not found in stack");
                    break;
                }
                Position position = tmp.equalsIgnoreCase("above") ? Position.ABOVE : Position.BELOW;
                try {
                    ProtocolStack.this.insertProtocol(prot, position, (Class<? extends Protocol>)neighbor.getClass());
                }
                catch (Exception e) {
                    ProtocolStack.this.log.error(Util.getMessage("FailedInsertingProtocol") + prot_name + " " + tmp + " " + neighbor_prot, e);
                }
                try {
                    ProtocolStack.callAfterCreationHook(prot, ProtocolStack.this.afterCreationHook());
                    prot.init();
                    prot.start();
                }
                catch (Exception e) {
                    ProtocolStack.this.log.error(Util.getMessage("FailedCreatingAnInstanceOf") + prot_name, e);
                }
            }
            return null;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"props", "max-list-print-size[=number]", "print-protocols", "\nremove-protocol=<name>", "\ninsert-protocol=<name>=above | below=<name>"};
        }
    };

    public ProtocolStack topProtocol(Protocol top) {
        this.top_prot = top;
        return this;
    }

    public ProtocolStack bottomProtocol(Protocol bottom) {
        this.bottom_prot = bottom;
        return this;
    }

    public ProtocolStack(JChannel channel) throws Exception {
        this.channel = channel;
        Class<ClassConfigurator> tmp = ClassConfigurator.class;
        tmp.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public ProtocolStack() {
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public ProtocolStack setChannel(JChannel ch) {
        this.channel = ch;
        return this;
    }

    public List<Protocol> getProtocols() {
        ArrayList<Protocol> v = new ArrayList<Protocol>(15);
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            v.add(p);
        }
        return v;
    }

    @Override
    public TP getTransport() {
        Object bottom = this.getBottomProtocol();
        return bottom instanceof TP ? (TP)bottom : null;
    }

    public Map<String, Map<String, Object>> dumpStats() {
        HashMap<String, Map<String, Object>> retval = new HashMap<String, Map<String, Object>>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            String prot_name = p.getName();
            if (prot_name == null) continue;
            TreeMap<String, Object> tmp = new TreeMap<String, Object>();
            ReflectUtils.dumpStats(p, tmp);
            if (tmp.isEmpty()) continue;
            retval.put(prot_name, tmp);
        }
        return retval;
    }

    public Map<String, Map<String, Object>> dumpStats(String protocol_name, List<String> attrs) {
        List prots = null;
        try {
            Class<? extends Protocol> cl = Util.loadProtocolClass(protocol_name, this.getClass());
            Object prot = this.findProtocol(cl);
            if (prot != null) {
                prots = Collections.singletonList(prot);
            }
        }
        catch (Exception cl) {
            // empty catch block
        }
        if (prots == null) {
            prots = this.findProtocols(protocol_name);
        }
        if (prots == null || prots.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Object>> retval = new HashMap<String, Map<String, Object>>();
        for (Protocol prot : prots) {
            String pname;
            TreeMap<String, Object> tmp = new TreeMap<String, Object>();
            ReflectUtils.dumpStats(prot, tmp);
            if (attrs != null && !attrs.isEmpty()) {
                Iterator it = tmp.keySet().iterator();
                while (it.hasNext()) {
                    String attrname = (String)it.next();
                    boolean found = false;
                    for (String attr : attrs) {
                        if (!attrname.startsWith(attr)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    it.remove();
                }
            }
            if (retval.containsKey(pname = prot.getName())) {
                retval.put(pname + "-" + prot.getId(), tmp);
                continue;
            }
            retval.put(pname, tmp);
        }
        return retval;
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuilder sb = new StringBuilder();
        List<Protocol> protocols = this.getProtocols();
        if (protocols == null || protocols.isEmpty()) {
            return null;
        }
        boolean first_colon_printed = false;
        Collections.reverse(protocols);
        for (Protocol prot : protocols) {
            Map<String, String> tmp;
            String prot_name = prot.getClass().getName();
            int index = prot_name.indexOf("org.jgroups.protocols.");
            if (index >= 0) {
                prot_name = prot_name.substring("org.jgroups.protocols.".length());
            }
            if (first_colon_printed) {
                sb.append(":");
            } else {
                first_colon_printed = true;
            }
            sb.append(prot_name);
            if (!include_properties || (tmp = ProtocolStack.getProps(prot)).isEmpty()) continue;
            boolean printed = false;
            sb.append("(");
            for (Map.Entry<String, String> entry : tmp.entrySet()) {
                if (printed) {
                    sb.append(";");
                } else {
                    printed = true;
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public String printProtocolSpecAsXML() {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.bottom_prot;
        int max_len = 30;
        sb.append("<config>\n");
        while (prot != null && !Objects.equals(prot.getClass(), ProtocolStack.class)) {
            String prot_name = prot.getClass().getName();
            if (prot_name == null) continue;
            sb.append("  <").append(prot_name).append(" ");
            Map<String, String> tmpProps = ProtocolStack.getProps(prot);
            if (tmpProps != null) {
                int len = prot_name.length();
                for (Map.Entry<String, String> entry : tmpProps.entrySet()) {
                    String s = entry.getKey() + "=\"" + entry.getValue() + "\" ";
                    if (len + s.length() > max_len) {
                        sb.append("\n       ");
                        len = 8;
                    }
                    sb.append(s);
                    len += s.length();
                }
            }
            sb.append("/>\n");
            prot = prot.getUpProtocol();
        }
        sb.append("</config>");
        return sb.toString();
    }

    public String printProtocolSpecAsPlainString() {
        return this.printProtocolSpecAsPlainString(false);
    }

    private String printProtocolSpecAsPlainString(boolean print_props) {
        StringBuilder sb = new StringBuilder();
        List<Protocol> protocols = this.getProtocols();
        if (protocols == null) {
            return null;
        }
        Collections.reverse(protocols);
        for (Protocol prot : protocols) {
            sb.append(prot.getClass().getName()).append("\n");
            if (!print_props) continue;
            Map<String, String> tmp = ProtocolStack.getProps(prot);
            for (Map.Entry<String, String> entry : tmp.entrySet()) {
                sb.append("    ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    private static Map<String, String> getProps(Protocol prot) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Class<?> clazz = prot.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            Property annotation;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object value;
                if (!field.isAnnotationPresent(Property.class) || (value = Util.getField(field, prot)) == null) continue;
                annotation = field.getAnnotation(Property.class);
                Class<? extends PropertyConverter> conv_class = annotation.converter();
                PropertyConverter conv = null;
                try {
                    conv = conv_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String tmp = conv != null ? conv.toString(value) : value.toString();
                retval.put(field.getName(), tmp);
            }
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Object value;
                String methodName = method.getName();
                if (!method.isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(method, clazz)) continue;
                annotation = method.getAnnotation(Property.class);
                LinkedList<String> possible_names = new LinkedList<String>();
                if (annotation.name() != null) {
                    possible_names.add(annotation.name());
                }
                possible_names.add(Util.methodNameToAttributeName(methodName));
                Field field = Util.findField(prot, possible_names);
                if (field == null || (value = Util.getField(field, prot)) == null) continue;
                Class<? extends PropertyConverter> conv_class = annotation.converter();
                PropertyConverter conv = null;
                try {
                    conv = conv_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String tmp = conv != null ? conv.toString(value) : value.toString();
                retval.put(field.getName(), tmp);
            }
        }
        return retval;
    }

    public void setup(List<ProtocolConfiguration> configs) throws Exception {
        this.setup(configs, null);
    }

    public void setup(List<ProtocolConfiguration> configs, ProtocolHook afterCreationHook) throws Exception {
        if (this.top_prot == null) {
            this.top_prot = new Configurator(this).setupProtocolStack(configs);
            this.top_prot.setUpProtocol(this);
            this.setDownProtocol(this.top_prot);
            this.bottom_prot = this.getBottomProtocol();
            this.initProtocolStack(configs, afterCreationHook);
        }
    }

    public ProtocolStack addProtocol(Protocol prot) {
        if (prot == null) {
            return this;
        }
        prot.setProtocolStack(this);
        prot.setUpProtocol(this);
        if (this.bottom_prot == null) {
            this.top_prot = this.bottom_prot = prot;
            return this;
        }
        prot.setDownProtocol(this.top_prot);
        ((Protocol)prot.getDownProtocol()).setUpProtocol(prot);
        this.top_prot = prot;
        return this;
    }

    public ProtocolStack addProtocols(Protocol ... prots) {
        if (prots != null) {
            for (Protocol prot : prots) {
                this.addProtocol(prot);
            }
        }
        return this;
    }

    public ProtocolStack addProtocols(List<Protocol> prots) {
        if (prots != null) {
            prots.forEach(this::addProtocol);
        }
        return this;
    }

    public void insertProtocol(Protocol prot, Position position, String neighbor_prot) throws Exception {
        if (neighbor_prot == null) {
            throw new IllegalArgumentException("neighbor_prot is null");
        }
        Object neighbor = this.findProtocol(neighbor_prot);
        if (neighbor == null) {
            throw new IllegalArgumentException("protocol " + neighbor_prot + " not found in " + this.printProtocolSpec(false));
        }
        if (position == Position.BELOW && neighbor instanceof TP) {
            throw new IllegalArgumentException("Cannot insert protocol " + prot.getName() + " below transport protocol");
        }
        this.insertProtocolInStack(prot, (Protocol)neighbor, position);
    }

    public void insertProtocolInStack(Protocol prot, Protocol neighbor, Position position) {
        Address local_address;
        if (position == Position.BELOW) {
            prot.setUpProtocol(neighbor);
            Object below = neighbor.getDownProtocol();
            prot.setDownProtocol((Protocol)below);
            if (below != null) {
                ((Protocol)below).setUpProtocol(prot);
            }
            neighbor.setDownProtocol(prot);
        } else {
            Object above = neighbor.getUpProtocol();
            this.checkAndSwitchTop(neighbor, prot);
            prot.setUpProtocol((Protocol)above);
            if (above != null) {
                ((Protocol)above).setDownProtocol(prot);
            }
            prot.setDownProtocol(neighbor);
            neighbor.setUpProtocol(prot);
        }
        Address address = local_address = this.getTransport() != null ? this.getTransport().getAddress() : null;
        if (local_address != null) {
            prot.setAddress(local_address);
        }
    }

    private void checkAndSwitchTop(Protocol oldTop, Protocol newTop) {
        if (oldTop == this.top_prot) {
            this.top_prot = newTop;
            this.top_prot.setUpProtocol(this);
        }
    }

    public void insertProtocol(Protocol prot, Position position, Class<? extends Protocol> neighbor_prot) throws Exception {
        if (neighbor_prot == null) {
            throw new IllegalArgumentException("neighbor_prot is null");
        }
        Object neighbor = this.findProtocol(neighbor_prot);
        if (neighbor == null) {
            throw new IllegalArgumentException("protocol \"" + neighbor_prot + "\" not found in " + this.stack.printProtocolSpec(false));
        }
        if (position == Position.BELOW && neighbor instanceof TP) {
            throw new IllegalArgumentException("\"" + prot + "\" cannot be inserted below the transport (" + neighbor + ")");
        }
        this.insertProtocolInStack(prot, (Protocol)neighbor, position);
    }

    @SafeVarargs
    public final void insertProtocol(Protocol prot, Position position, Class<? extends Protocol> ... neighbor_prots) throws Exception {
        if (neighbor_prots == null) {
            throw new IllegalArgumentException("neighbor_prots is null");
        }
        Object neighbor = this.findProtocol(neighbor_prots);
        if (neighbor == null) {
            throw new IllegalArgumentException("protocol \"" + Arrays.toString(neighbor_prots) + "\" not found in " + this.stack.printProtocolSpec(false));
        }
        this.insertProtocolInStack(prot, (Protocol)neighbor, position);
    }

    public void insertProtocolAtTop(Protocol prot) {
        Address local_address;
        if (prot == null) {
            throw new IllegalArgumentException("prot needs to be non-null");
        }
        Class<?> clazz = prot.getClass();
        Object existing_instance = this.findProtocol((Class<? extends Protocol>)clazz);
        if (existing_instance != null) {
            return;
        }
        this.top_prot.up_prot = prot;
        prot.down_prot = this.top_prot;
        prot.up_prot = this;
        this.top_prot = prot;
        Address address = local_address = this.getTransport() != null ? this.getTransport().getAddress() : null;
        if (local_address != null) {
            prot.setAddress(local_address);
        }
        this.log.debug("inserted " + prot + " at the top of the stack");
    }

    public <T extends Protocol> T removeProtocol(String prot_name) {
        if (prot_name == null) {
            return null;
        }
        return this.removeProtocol(this.findProtocol(prot_name));
    }

    public ProtocolStack removeProtocols(String ... protocols) {
        for (String protocol : protocols) {
            this.removeProtocol((Protocol)((Object)protocol));
        }
        return this;
    }

    @SafeVarargs
    public final ProtocolStack removeProtocols(Class<? extends Protocol> ... protocols) {
        for (Class<? extends Protocol> protocol : protocols) {
            this.removeProtocol((Protocol)((Object)protocol));
        }
        return this;
    }

    @SafeVarargs
    public final <T extends Protocol> T removeProtocol(Class<? extends Protocol> ... protocols) {
        for (Class<? extends Protocol> cl : protocols) {
            Class<? extends Protocol> tmp = this.removeProtocol((T)((Object)cl));
            if (tmp == null) continue;
            return (T)tmp;
        }
        return null;
    }

    public <T extends Protocol> T removeProtocol(Class<? extends Protocol> prot) {
        if (prot == null) {
            return null;
        }
        return this.removeProtocol(this.findProtocol(prot));
    }

    public <T extends Protocol> T removeProtocol(T prot) {
        if (prot == null) {
            return null;
        }
        Object above = prot.getUpProtocol();
        Object below = prot.getDownProtocol();
        this.checkAndSwitchTop(prot, (Protocol)below);
        if (above != null) {
            ((Protocol)above).setDownProtocol((Protocol)below);
        }
        if (below != null) {
            ((Protocol)below).setUpProtocol((Protocol)above);
        }
        prot.setUpProtocol(null);
        prot.setDownProtocol(null);
        try {
            prot.stop();
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedStopping") + prot.getName() + ": " + t);
        }
        try {
            prot.destroy();
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedDestroying") + prot.getName() + ": " + t);
        }
        return prot;
    }

    public <T extends Protocol> T findProtocol(String name) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            String prot_name = tmp.getName();
            if (!Objects.equals(prot_name, name)) continue;
            return (T)tmp;
        }
        return null;
    }

    public <T extends Protocol> List<T> findProtocols(String regexp) {
        ArrayList<Protocol> retval = null;
        Pattern pattern = Pattern.compile(regexp);
        for (Protocol prot = this.top_prot; prot != null; prot = prot.getDownProtocol()) {
            String prot_name = prot.getName();
            if (!pattern.matcher(prot_name).matches()) continue;
            if (retval == null) {
                retval = new ArrayList<Protocol>();
            }
            retval.add(prot);
        }
        return retval;
    }

    public <T extends Protocol> T getBottomProtocol() {
        ProtocolStack curr_prot;
        for (curr_prot = this; curr_prot != null && curr_prot.getDownProtocol() != null; curr_prot = curr_prot.getDownProtocol()) {
        }
        return (T)curr_prot;
    }

    public Protocol getTopProtocol() {
        return this.top_prot;
    }

    public <T extends Protocol> T findProtocol(Class<? extends Protocol> clazz) {
        return ProtocolStack.findProtocol(this.top_prot, true, clazz);
    }

    public static <T extends Protocol> T findProtocol(Protocol start, boolean down2, Class<? extends Protocol> clazz) {
        Protocol tmp = start;
        while (tmp != null) {
            Class<?> protClass = tmp.getClass();
            if (clazz.isAssignableFrom(protClass)) {
                return (T)tmp;
            }
            tmp = down2 ? tmp.getDownProtocol() : tmp.getUpProtocol();
        }
        return null;
    }

    @SafeVarargs
    public final <T extends Protocol> T findProtocol(Class<? extends Protocol> ... classes) {
        for (Class<? extends Protocol> clazz : classes) {
            T prot = this.findProtocol(clazz);
            if (prot == null) continue;
            return prot;
        }
        return null;
    }

    public void replaceProtocol(Protocol existing_prot, Protocol new_prot) throws Exception {
        Object up_neighbor = existing_prot.getUpProtocol();
        Object down_neighbor = existing_prot.getDownProtocol();
        new_prot.setUpProtocol((Protocol)existing_prot.getUpProtocol());
        new_prot.setDownProtocol((Protocol)existing_prot.getDownProtocol());
        ((Protocol)up_neighbor).setDownProtocol(new_prot);
        if (down_neighbor != null) {
            ((Protocol)down_neighbor).setUpProtocol(new_prot);
        }
        existing_prot.setDownProtocol(null);
        existing_prot.setUpProtocol(null);
        existing_prot.stop();
        existing_prot.destroy();
        if (new_prot.getUpProtocol() == this) {
            this.top_prot = new_prot;
        }
        ProtocolStack.callAfterCreationHook(new_prot, this.afterCreationHook());
        new_prot.init();
    }

    protected Protocol createProtocol(String classname) throws Exception {
        Class<? extends Protocol> clazz = Util.loadProtocolClass(classname, this.getClass());
        Protocol retval = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (retval == null) {
            throw new Exception("creation of instance for protocol " + classname + "failed");
        }
        retval.setProtocolStack(this);
        return retval;
    }

    @Override
    public void init() throws Exception {
        InetAddress resolved_addr;
        List<Protocol> protocols = this.getProtocols();
        Collections.reverse(protocols);
        this.top_prot = Configurator.connectProtocols(protocols);
        this.top_prot.setUpProtocol(this);
        this.setDownProtocol(this.top_prot);
        this.bottom_prot = this.getBottomProtocol();
        StackType ip_version = Util.getIpStackType();
        TP tp = this.getTransport();
        InetAddress inetAddress = resolved_addr = tp != null ? tp.getBindAddress() : null;
        if (resolved_addr != null) {
            ip_version = resolved_addr instanceof Inet6Address ? StackType.IPv6 : StackType.IPv4;
        } else if (ip_version == StackType.Dual) {
            ip_version = StackType.IPv4;
        }
        Configurator.setDefaultAddressValues(protocols, ip_version);
        this.initProtocolStack(null);
    }

    public void initProtocolStack(List<ProtocolConfiguration> configs) throws Exception {
        this.initProtocolStack(configs, null);
    }

    public void initProtocolStack(List<ProtocolConfiguration> configs, ProtocolHook afterCreationHook) throws Exception {
        List<Protocol> protocols = this.getProtocols();
        Collections.reverse(protocols);
        try {
            for (int i = 0; i < protocols.size(); ++i) {
                Protocol prot = protocols.get(i);
                if (prot.getProtocolStack() == null) {
                    prot.setProtocolStack(this);
                }
                ProtocolStack.callAfterCreationHook(prot, prot.afterCreationHook());
                if (afterCreationHook != null) {
                    afterCreationHook.afterCreation(prot);
                }
                prot.init();
                ProtocolStack.initComponents(prot, configs != null ? configs.get(i) : null);
                List<? extends Policy> pols = prot.getPolicies();
                if (pols == null || pols.isEmpty()) continue;
                for (Policy policy : pols) {
                    policy.check(prot);
                }
            }
        }
        catch (Exception ex) {
            this.destroy();
            throw ex;
        }
    }

    public static void initComponents(Protocol p, ProtocolConfiguration cfg) throws Exception {
        HashMap properties = cfg != null ? cfg.getProperties() : new HashMap();
        HashMap props = new HashMap();
        HashMap prefixes = new HashMap();
        Ref<Object> ex = new Ref<Object>(null);
        Util.forAllComponentTypes(p.getClass(), (cl, prefix) -> {
            if (ex.isSet()) {
                return;
            }
            if (prefix == null || prefix.trim().isEmpty()) {
                ex.set(new IllegalArgumentException(String.format("component (class=%s) in %s must have a prefix", cl.getSimpleName(), p.getName())));
                return;
            }
            if (prefixes.containsKey(prefix)) {
                ex.set(new IllegalArgumentException(String.format("multiple components (class=%s) in %s have same prefix '%s'", cl.getSimpleName(), p.getName(), prefix)));
            } else {
                prefixes.put(prefix, cl);
            }
        });
        if (ex.isSet()) {
            throw (Exception)ex.get();
        }
        Util.forAllComponentTypes(p.getClass(), (c, prefix) -> {
            String key = prefix + ".";
            properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(key)).forEach(e -> props.put((String)e.getKey(), (String)e.getValue()));
        });
        ex.set(null);
        InetAddress resolved_addr = p.getTransport() != null ? p.getTransport().getBindAddress() : null;
        StackType ip_version = resolved_addr instanceof Inet6Address ? StackType.IPv6 : StackType.IPv4;
        Util.forAllComponents(p, (comp, prefix) -> {
            try {
                if (ex.isSet()) {
                    return;
                }
                HashMap<String, String> m = new HashMap<String, String>();
                String key = prefix + ".";
                props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(key)).forEach(e -> m.put(((String)e.getKey()).substring(prefix.length() + 1), (String)e.getValue()));
                props.keySet().removeIf(k -> k.startsWith(key));
                if (!m.isEmpty()) {
                    Configurator.initializeAttrs(comp, m, ip_version);
                    if (!m.isEmpty()) {
                        String fmt = "the following properties in %s:%s (%s) are not recognized: %s";
                        ex.set(new IllegalArgumentException(String.format(fmt, p.getName(), prefix, comp.getClass().getSimpleName(), m)));
                    }
                }
                Configurator.setDefaultAddressValues(comp, ip_version);
                if (comp instanceof Lifecycle) {
                    ((Lifecycle)comp).init();
                }
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(String.format("failed initializing component %s in protocol %s: %s", comp.getClass().getSimpleName(), p, e2));
            }
        });
        if (ex.isSet()) {
            throw (Exception)ex.get();
        }
        if (!props.isEmpty()) {
            String fmt = "configuration error: the following component properties in %s are not recognized: %s";
            throw new IllegalArgumentException(String.format(fmt, p.getName(), props));
        }
    }

    @Override
    public void destroy() {
        if (this.top_prot != null) {
            this.getProtocols().forEach(Protocol::destroy);
        }
    }

    public void startStack() throws Exception {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        List<Protocol> protocols = this.getProtocols();
        Collections.reverse(protocols);
        for (Protocol prot : protocols) {
            prot.start();
        }
        TP transport = this.getTransport();
        transport.registerProbeHandler(this.props_handler);
    }

    public void stopStack(String cluster) {
        if (this.stopped) {
            return;
        }
        this.getProtocols().forEach(Protocol::stop);
        TP transport = this.getTransport();
        transport.unregisterProbeHandler(this.props_handler);
        this.stopped = true;
    }

    @Override
    public String getName() {
        return "ProtocolStack";
    }

    @Override
    public Object up(Event evt) {
        return this.channel.up(evt);
    }

    @Override
    public Object up(Message msg) {
        return this.channel.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        this.channel.up(batch);
    }

    @Override
    public Object down(Event evt) {
        if (this.top_prot != null) {
            return this.top_prot.down(evt);
        }
        return null;
    }

    @Override
    public Object down(Message msg) {
        return this.top_prot != null ? this.top_prot.down(msg) : null;
    }

    @Override
    public CompletableFuture<Object> down(Message msg, boolean async) {
        return this.top_prot != null ? this.top_prot.down(msg, async) : null;
    }

    protected static void callAfterCreationHook(Protocol prot, String classname) throws Exception {
        if (classname == null || prot == null) {
            return;
        }
        Class<?> clazz = Util.loadClass(classname, prot.getClass());
        ProtocolHook hook = (ProtocolHook)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        hook.afterCreation(prot);
    }

    public static enum Position {
        ABOVE,
        BELOW;

    }
}

