/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.util.SeqnoList;

public class CheckGaps {
    public static void main(String[] args2) throws IOException {
        LinkedList<Long> list = new LinkedList<Long>();
        ConcurrentSkipListSet<Long> set = new ConcurrentSkipListSet<Long>();
        AtomicLong high = new AtomicLong();
        if (args2.length > 1 && args2[0].equals("-f")) {
            Files.lines(Path.of(args2[1], new String[0])).forEach(line -> {
                String[] numbers;
                line = line.replace(",", "").replace("[", "").replace("]", "");
                for (String s : numbers = line.split("\\s+")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    long number = Long.parseLong(s);
                    list.add(number);
                    set.add(number);
                    high.set(Math.max(high.get(), number));
                }
            });
        } else {
            for (int i = 0; i < args2.length; ++i) {
                long num = Long.parseLong(args2[i]);
                list.add(num);
                set.add(num);
                high.set(Math.max(high.get(), num));
            }
        }
        int size = list.size();
        int set_size = set.size();
        long low = (Long)set.iterator().next();
        long duplicates = size - set_size;
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            long l = (Long)iterator2.next();
            list.remove(l);
        }
        System.out.printf("read %d numbers (%d duplicates), low=%d, high=%d\n", size, duplicates, low, high.get());
        if (!list.isEmpty()) {
            ConcurrentSkipListSet<Long> tmp = new ConcurrentSkipListSet<Long>(list);
            long first = (Long)tmp.iterator().next();
            SeqnoList sl = new SeqnoList(size, first);
            sl.add(tmp);
            System.out.printf("duplicates: %s\n", sl);
        }
        HashSet<Long> correct_set = new HashSet<Long>();
        for (long i = low; i < high.get(); ++i) {
            correct_set.add(i);
        }
        set.forEach(correct_set::remove);
        System.out.printf("missing seqnos: %s\n", correct_set);
    }
}

