/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.logging.Log;
import org.jgroups.util.ThreadCreator;
import org.jgroups.util.ThreadFactory;

public class DefaultThreadFactory
implements ThreadFactory {
    protected final String baseName;
    protected final boolean createDaemons;
    protected final boolean use_numbering;
    protected final AtomicInteger counter = new AtomicInteger();
    protected boolean includeClusterName;
    protected String clusterName;
    protected boolean includeLocalAddress;
    protected String address;
    protected boolean use_vthreads;
    protected Log log;

    public DefaultThreadFactory(String base_name, boolean createDaemons) {
        this(base_name, createDaemons, false);
    }

    public DefaultThreadFactory(String base_name, boolean createDaemons, boolean use_numbering) {
        this.baseName = base_name;
        this.createDaemons = createDaemons;
        this.use_numbering = use_numbering;
    }

    @Override
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.includeClusterName = pattern.contains("c");
            this.includeLocalAddress = pattern.contains("l");
        }
    }

    @Override
    public void setIncludeClusterName(boolean includeClusterName) {
        this.includeClusterName = includeClusterName;
    }

    @Override
    public void setClusterName(String channelName) {
        this.clusterName = channelName;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Deprecated(forRemoval=true)
    public boolean useFibers() {
        return this.useVirtualThreads();
    }

    @Deprecated(forRemoval=true)
    public <T extends DefaultThreadFactory> T useFibers(boolean f) {
        return this.useVirtualThreads(f);
    }

    @Override
    public boolean useVirtualThreads() {
        return this.use_vthreads;
    }

    public <T extends DefaultThreadFactory> T useVirtualThreads(boolean f) {
        this.use_vthreads = f;
        return (T)this;
    }

    public <T extends DefaultThreadFactory> T log(Log l) {
        this.log = l;
        return (T)this;
    }

    @Override
    public Thread newThread(Runnable r, String name) {
        return this.newThread(r, name, null, null);
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread(r, this.baseName, null, null);
    }

    protected Thread newThread(Runnable r, String name, String addr, String cluster_name) {
        String thread_name = this.getNewThreadName(name, addr, cluster_name);
        return ThreadCreator.createThread(r, thread_name, this.createDaemons, this.use_vthreads);
    }

    @Override
    public void renameThread(String base_name, Thread thread2) {
        this.renameThread(base_name, thread2, this.address, this.clusterName);
    }

    public void renameThread(String base_name, Thread thread2, String addr, String cluster_name) {
        String thread_name = this.getThreadName(base_name, thread2, addr, cluster_name);
        if (thread_name != null) {
            thread2.setName(thread_name);
        }
    }

    public void renameThread(Thread thread2) {
        this.renameThread(null, thread2);
    }

    protected String getThreadName(String base_name, Thread thread2, String addr, String cluster_name) {
        if (thread2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : thread2.getName());
        if (this.use_numbering) {
            int id = this.counter.incrementAndGet();
            sb.append("-").append(id);
        }
        if (cluster_name == null) {
            cluster_name = this.clusterName;
        }
        if (addr == null) {
            addr = this.address;
        }
        if (!this.includeClusterName && !this.includeLocalAddress) {
            return sb.toString();
        }
        if (this.includeClusterName) {
            sb.append(',').append(cluster_name);
        }
        if (this.includeLocalAddress) {
            sb.append(',').append(addr);
        }
        if (this.use_numbering || this.includeClusterName || this.includeLocalAddress) {
            return sb.toString();
        }
        return null;
    }

    protected String getNewThreadName(String base_name, String addr, String cluster_name) {
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : "thread");
        if (this.use_numbering) {
            int id = this.counter.incrementAndGet();
            sb.append("-").append(id);
        }
        if (cluster_name == null) {
            cluster_name = this.clusterName;
        }
        if (addr == null) {
            addr = this.address;
        }
        if (!this.includeClusterName && !this.includeLocalAddress) {
            return sb.toString();
        }
        if (this.includeClusterName) {
            sb.append(',').append(cluster_name);
        }
        if (this.includeLocalAddress) {
            sb.append(',').append(addr);
        }
        return sb.toString();
    }
}

