/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import org.jgroups.logging.Log;
import org.jgroups.util.SuppressCache;
import org.jgroups.util.Util;

public class SuppressLog<T> {
    protected final Log log;
    protected final SuppressCache<T> cache;
    protected final String message_format;
    protected final String suppress_format;

    public SuppressLog(Log log, String message_key) {
        this.log = log;
        this.cache = new SuppressCache();
        this.message_format = Util.getMessage(message_key);
        this.suppress_format = Util.getMessage("SuppressMsg");
    }

    public SuppressCache<T> getCache() {
        return this.cache;
    }

    public void log(Level level, T key, long timeout2, Object ... args2) {
        SuppressCache.Value val = this.cache.putIfAbsent(key, timeout2);
        if (val == null) {
            return;
        }
        String message = val.count() == 1 ? String.format(this.message_format, args2) : String.format(this.message_format, args2) + " " + String.format(this.suppress_format, val.count(), Util.printTime(val.age(), TimeUnit.MILLISECONDS));
        switch (level) {
            case error: {
                this.log.error(message);
                break;
            }
            case warn: {
                this.log.warn(message);
                break;
            }
            case trace: {
                this.log.trace(message);
            }
        }
    }

    public void removeExpired(long timeout2) {
        this.cache.removeExpired(timeout2);
    }

    public static enum Level {
        error,
        warn,
        trace;

    }
}

