/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import eu.maveniverse.maven.mimir.daemon.DaemonConfig;
import eu.maveniverse.maven.mimir.daemon.DaemonServer;
import eu.maveniverse.maven.mimir.daemon.protocol.Handle;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.impl.Executors;
import eu.maveniverse.maven.mimir.shared.node.RemoteNode;
import eu.maveniverse.maven.mimir.shared.node.RemoteNodeFactory;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import eu.maveniverse.maven.mimir.shared.node.SystemNodeFactory;
import eu.maveniverse.maven.shared.core.component.CloseableConfigSupport;
import eu.maveniverse.maven.shared.core.fs.DirectoryLocker;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.WireModule;

@Named
@Singleton
public class Daemon
extends CloseableConfigSupport<DaemonConfig>
implements Closeable {
    private final ExecutorService executor;
    private final SystemNode<?> systemNode;
    private final List<RemoteNode<?>> remoteNodes;
    private final Handle.ServerHandle serverHandle;

    public static void main(String[] args2) {
        try {
            SessionConfig sessionConfig = SessionConfig.daemonDefaults().build();
            final DaemonConfig daemonConfig = DaemonConfig.with(sessionConfig);
            Daemon daemon = Guice.createInjector(new WireModule(new AbstractModule(){

                @Override
                protected void configure() {
                    this.bind(DaemonConfig.class).toInstance(daemonConfig);
                }
            }, new SpaceModule((ClassSpace)new URLClassSpace(Daemon.class.getClassLoader()), BeanScanning.INDEX, true))).getInstance(Daemon.class);
            Runtime.getRuntime().addShutdownHook(new Thread(daemon::shutdown));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    @Inject
    public Daemon(DaemonConfig daemonConfig, SystemNode<?> systemNode, Map<String, RemoteNodeFactory> remoteNodeFactories, Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories) throws IOException {
        super(daemonConfig);
        this.systemNode = Objects.requireNonNull(systemNode, "systemNode");
        Objects.requireNonNull(remoteNodeFactories, "remoteNodeFactories");
        ArrayList<RemoteNode> nds = new ArrayList<RemoteNode>();
        for (RemoteNodeFactory remoteNodeFactory : remoteNodeFactories.values()) {
            Optional<RemoteNode<?>> optional = remoteNodeFactory.createNode(((DaemonConfig)this.config).config());
            optional.ifPresent(nds::add);
        }
        nds.sort(Comparator.comparing(RemoteNode::distance));
        this.remoteNodes = List.copyOf(nds);
        this.executor = Executors.executorService();
        Files.createDirectories(((DaemonConfig)this.config).daemonLockDir(), new FileAttribute[0]);
        DirectoryLocker.INSTANCE.lockDirectory(((DaemonConfig)this.config).daemonLockDir(), true);
        Path socketPath = daemonConfig.socketPath();
        Files.deleteIfExists(socketPath);
        this.serverHandle = Handle.serverDomainSocket(socketPath);
        this.logger.info("Mimir Daemon {} started", (Object)((DaemonConfig)this.config).config().mimirVersion());
        this.logger.info("  PID: {}", (Object)ProcessHandle.current().pid());
        this.logger.info("  Basedir: {}", (Object)((DaemonConfig)this.config).config().basedir());
        this.logger.info("  Properties: {}", (Object)((DaemonConfig)this.config).config().propertiesPath());
        this.logger.info("  Supported checksums: {}", (Object)checksumAlgorithmFactories.keySet());
        this.logger.info("  Socket: {}", (Object)socketPath);
        this.logger.info("  System Node: {}", (Object)systemNode);
        this.logger.info("  Using checksums: {}", (Object)systemNode.checksumAlgorithms());
        this.logger.info("  {} remote node(s):", (Object)this.remoteNodes.size());
        for (RemoteNode<?> remoteNode : this.remoteNodes) {
            this.logger.info("    {}", (Object)remoteNode);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("daemon.pid", Long.toString(ProcessHandle.current().pid()));
        hashMap.put("daemon.version", ((DaemonConfig)this.config).config().mimirVersion());
        Predicate<Request> predicate = req -> Objects.equals(req.requireData("node.version"), daemonData.get("daemon.version"));
        try {
            while (this.serverHandle.isOpen()) {
                Handle handle = this.serverHandle.accept();
                this.executor.submit(new DaemonServer(handle, hashMap, systemNode, this.remoteNodes, predicate, this::shutdown));
            }
        }
        catch (AsynchronousCloseException handle) {
        }
        catch (Exception e) {
            this.logger.error("Error while accepting client connection", e);
        }
    }

    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException e) {
            this.logger.warn("Failed to close daemon", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        try {
            try {
                this.serverHandle.close();
            }
            catch (Exception e) {
                this.logger.warn("Error closing server socket channel", e);
            }
            try {
                this.executor.shutdown();
            }
            catch (Exception e) {
                this.logger.warn("Error closing executor", e);
            }
            for (RemoteNode<?> node : this.remoteNodes) {
                try {
                    node.close();
                }
                catch (IOException e) {
                    this.logger.warn("Error closing node", e);
                }
            }
            try {
                this.systemNode.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing local node", e);
            }
        }
        finally {
            DirectoryLocker.INSTANCE.unlockDirectory(((DaemonConfig)this.config).daemonLockDir());
            this.logger.info("Daemon stopped");
        }
    }

    static {
        if (System.getProperty("org.slf4j.simpleLogger.logFile") == null) {
            System.setProperty("org.slf4j.simpleLogger.logFile", "System.out");
        }
    }

    @Named
    public static final class SystemNodeProvider
    implements Provider<SystemNode<?>> {
        private final SystemNode<?> systemNode;

        @Inject
        public SystemNodeProvider(DaemonConfig daemonConfig, Map<String, SystemNodeFactory> systemNodeFactories) throws IOException {
            Objects.requireNonNull(systemNodeFactories, "systemNodeFactories");
            SystemNodeFactory systemNodeFactory = systemNodeFactories.get(daemonConfig.systemNode());
            if (systemNodeFactory == null) {
                throw new IllegalArgumentException("Unknown system node: " + daemonConfig.systemNode());
            }
            this.systemNode = systemNodeFactory.createNode(daemonConfig.config());
        }

        @Override
        public SystemNode<?> get() {
            return this.systemNode;
        }
    }
}

