/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.daemon.protocol;

import eu.maveniverse.maven.mimir.daemon.protocol.ImmutableRequest;
import eu.maveniverse.maven.mimir.daemon.protocol.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Request
extends Message {
    public static final String CMD_HELLO = "HELLO";
    public static final String CMD_BYE = "BYE";
    public static final String CMD_LOCATE = "LOCATE";
    public static final String CMD_TRANSFER = "TRANSFER";
    public static final String CMD_LS_CHECKSUMS = "LS_CHECKSUMS";
    public static final String CMD_STORE_PATH = "STORE_PATH";
    public static final String DATA_KEYSTRING = "keyString";
    public static final String DATA_PATHSTRING = "pathString";
    public static final String DATA_SHUTDOWN = "shutdown";

    public abstract String cmd();

    public static Request hello(Map<String, String> data) {
        Objects.requireNonNull(data, "data");
        return Request.request(Map.of(), CMD_HELLO, data);
    }

    public static Request bye(Map<String, String> session, boolean shutdown) {
        Objects.requireNonNull(session, "session");
        HashMap<String, String> data = new HashMap<String, String>();
        if (shutdown) {
            data.put(DATA_SHUTDOWN, Boolean.TRUE.toString());
        }
        return Request.request(session, CMD_BYE, data);
    }

    public static Request locate(Map<String, String> session, String keyString) {
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(keyString, DATA_KEYSTRING);
        return Request.request(session, CMD_LOCATE, Map.of(DATA_KEYSTRING, keyString));
    }

    public static Request lsChecksums(Map<String, String> session) {
        Objects.requireNonNull(session, "session");
        return Request.request(session, CMD_LS_CHECKSUMS, Map.of());
    }

    public static Request transfer(Map<String, String> session, String keyString, String filePath) {
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(keyString, DATA_KEYSTRING);
        Objects.requireNonNull(filePath, "filePath");
        HashMap<String, String> requestData = new HashMap<String, String>();
        requestData.put(DATA_KEYSTRING, keyString);
        requestData.put(DATA_PATHSTRING, filePath);
        return Request.request(session, CMD_TRANSFER, requestData);
    }

    public static Request storePath(Map<String, String> session, String keyString, String filePath, Map<String, String> data) {
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(keyString, DATA_KEYSTRING);
        Objects.requireNonNull(filePath, "filePath");
        Objects.requireNonNull(data, "data");
        HashMap<String, String> requestData = new HashMap<String, String>(data);
        requestData.put(DATA_KEYSTRING, keyString);
        requestData.put(DATA_PATHSTRING, filePath);
        return Request.request(session, CMD_STORE_PATH, requestData);
    }

    private static Request request(Map<String, String> session, String cmd, Map<String, String> data) {
        return ImmutableRequest.builder().cmd(cmd).data(data).session(session).build();
    }
}

