/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.file;

import eu.maveniverse.maven.mimir.node.file.FileEntry;
import eu.maveniverse.maven.mimir.shared.impl.Utils;
import eu.maveniverse.maven.mimir.shared.impl.checksum.ChecksumEnforcer;
import eu.maveniverse.maven.mimir.shared.impl.checksum.ChecksumInputStream;
import eu.maveniverse.maven.mimir.shared.impl.node.NodeSupport;
import eu.maveniverse.maven.mimir.shared.naming.Key;
import eu.maveniverse.maven.mimir.shared.node.Entry;
import eu.maveniverse.maven.mimir.shared.node.LocalEntry;
import eu.maveniverse.maven.mimir.shared.node.RemoteEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import eu.maveniverse.maven.shared.core.fs.DirectoryLocker;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public final class FileNode
extends NodeSupport<FileEntry>
implements SystemNode<FileEntry> {
    private final Path basedir;
    private final boolean mayLink;
    private final boolean exclusiveAccess;
    private final boolean cachePurge;
    private final Function<URI, Key> keyResolver;
    private final List<String> checksumAlgorithms;
    private final Map<String, ChecksumAlgorithmFactory> checksumFactories;
    private final DirectoryLocker directoryLocker;

    public FileNode(Path basedir, boolean mayLink, boolean exclusiveAccess, boolean cachePurge, Function<URI, Key> keyResolver, List<String> checksumAlgorithms, Map<String, ChecksumAlgorithmFactory> checksumFactories, DirectoryLocker directoryLocker) throws IOException {
        super("file");
        this.basedir = basedir;
        this.mayLink = mayLink;
        this.exclusiveAccess = exclusiveAccess;
        this.cachePurge = cachePurge;
        this.keyResolver = Objects.requireNonNull(keyResolver, "keyResolver");
        this.checksumAlgorithms = List.copyOf(checksumAlgorithms);
        this.checksumFactories = Map.copyOf(checksumFactories);
        this.directoryLocker = Objects.requireNonNull(directoryLocker);
        Files.createDirectories(basedir, new FileAttribute[0]);
        this.directoryLocker.lockDirectory(basedir, exclusiveAccess);
    }

    @Override
    public List<String> checksumAlgorithms() {
        return this.checksumAlgorithms;
    }

    @Override
    public Map<String, ChecksumAlgorithmFactory> checksumFactories() {
        return this.checksumFactories;
    }

    @Override
    public Optional<FileEntry> locate(URI key) throws IOException {
        this.checkClosed();
        Path path = this.resolveKey(key);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            Map<String, String> data = this.loadMetadata(path);
            return Optional.of(this.createEntry(path, Utils.splitMetadata(data), Utils.splitChecksums(data)));
        }
        return Optional.empty();
    }

    @Override
    public FileEntry store(URI key, Path file, Map<String, String> md, Map<String, String> checksums) throws IOException {
        ChecksumEnforcer checksumEnforcer;
        this.checkClosed();
        Path path = this.resolveKey(key);
        HashMap<String, String> metadata = new HashMap<String, String>(md);
        FileTime fileTime = Files.getLastModifiedTime(file, new LinkOption[0]);
        try (FileUtils.CollocatedTempFile f = FileUtils.newTempFile(path);){
            checksumEnforcer = new ChecksumEnforcer(checksums);
            try (ChecksumInputStream enforced = new ChecksumInputStream(Files.newInputStream(file, new OpenOption[0]), this.checksumAlgorithms().stream().map(a -> new AbstractMap.SimpleEntry<String, ChecksumAlgorithm>((String)a, this.checksumFactories.get(a).getAlgorithm())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), checksumEnforcer);){
                Files.copy(enforced, f.getPath(), new CopyOption[0]);
                Files.setLastModifiedTime(f.getPath(), fileTime);
            }
            Entry.setContentLength(metadata, Files.size(file));
            Entry.setContentLastModified(metadata, fileTime.toInstant());
            this.storeMetadata(path, Utils.mergeEntry(metadata, checksumEnforcer.getChecksums()));
            f.move();
        }
        return new FileEntry(metadata, checksumEnforcer.getChecksums(), path, this.mayLink);
    }

    @Override
    public boolean exclusiveAccess() {
        return this.exclusiveAccess;
    }

    @Override
    public FileEntry store(URI key, Entry entry) throws IOException {
        this.checkClosed();
        Path path = this.resolveKey(key);
        if (entry instanceof RemoteEntry) {
            RemoteEntry remoteEntry = (RemoteEntry)entry;
            try (FileUtils.CollocatedTempFile f = FileUtils.newTempFile(path);){
                remoteEntry.handleContent(inputStream2 -> {
                    ChecksumEnforcer checksumEnforcer = new ChecksumEnforcer(entry.checksums());
                    try (ChecksumInputStream enforced = new ChecksumInputStream(inputStream2, this.checksumAlgorithms().stream().map(a -> new AbstractMap.SimpleEntry<String, ChecksumAlgorithm>((String)a, this.checksumFactories.get(a).getAlgorithm())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), checksumEnforcer);){
                        Files.copy(enforced, f.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    this.storeMetadata(path, Utils.mergeEntry(entry.metadata(), checksumEnforcer.getChecksums()));
                    f.move();
                });
            }
        } else if (entry instanceof LocalEntry) {
            LocalEntry localEntry = (LocalEntry)entry;
            this.storeMetadata(path, Utils.mergeEntry(entry));
            localEntry.transferTo(path);
        } else {
            throw new UnsupportedOperationException("Unsupported entry type: " + String.valueOf(entry.getClass()));
        }
        return this.createEntry(path, entry.metadata(), entry.checksums());
    }

    private Path resolveKey(URI key) {
        Key resolved = this.keyResolver.apply(key);
        return this.basedir.resolve(resolved.container()).resolve(resolved.name());
    }

    private FileEntry createEntry(Path file, Map<String, String> metadata, Map<String, String> checksums) throws IOException {
        HashMap<String, String> md = new HashMap<String, String>(metadata);
        Entry.setContentLength(md, Files.size(file));
        Entry.setContentLastModified(md, Files.getLastModifiedTime(file, new LinkOption[0]).toInstant());
        return new FileEntry(md, checksums, file, this.mayLink);
    }

    @Override
    protected void doClose() throws IOException {
        try {
            if (this.exclusiveAccess && this.cachePurge) {
                this.purgeCaches();
            }
        }
        finally {
            this.directoryLocker.unlockDirectory(this.basedir);
        }
    }

    private void purgeCaches() {
        this.logger.info("Purging caches...");
    }

    private void storeMetadata(Path file, Map<String, String> metadata) throws IOException {
        Path md = file.getParent().resolve("_" + String.valueOf(file.getFileName()));
        try (MessagePacker packer = MessagePack.newDefaultPacker(Files.newOutputStream(md, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            packer.packMapHeader(metadata.size());
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                packer.packString(entry.getKey());
                packer.packString(entry.getValue());
            }
        }
    }

    private Map<String, String> loadMetadata(Path file) throws IOException {
        Path md = file.getParent().resolve("_" + String.valueOf(file.getFileName()));
        if (!Files.isRegularFile(md, new LinkOption[0])) {
            this.recreateMetadata(file);
        }
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker(Files.newInputStream(md, new OpenOption[0]));){
            HashMap<String, String> metadata = new HashMap<String, String>();
            int entries = unpacker.unpackMapHeader();
            for (int i = 0; i < entries; ++i) {
                String key = unpacker.unpackString();
                String value = unpacker.unpackString();
                metadata.put(key, value);
            }
            HashMap<String, String> hashMap = metadata;
            return hashMap;
        }
    }

    private void recreateMetadata(Path file) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Entry.setContentLength(metadata, Files.size(file));
        Entry.setContentLastModified(metadata, Files.getLastModifiedTime(file, new LinkOption[0]).toInstant());
        Map<String, String> checksums = FileNode.calculate(file, this.checksumAlgorithms().stream().map(a -> new AbstractMap.SimpleEntry<String, ChecksumAlgorithm>((String)a, this.checksumFactories.get(a).getAlgorithm())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
        this.storeMetadata(file, Utils.mergeEntry(metadata, checksums));
    }

    private static Map<String, String> calculate(Path path, Map<String, ChecksumAlgorithm> checksums) throws IOException {
        AtomicReference<Object> checksumsRef = new AtomicReference<Object>(null);
        try (ChecksumInputStream stream = new ChecksumInputStream(Files.newInputStream(path, new OpenOption[0]), checksums, checksumsRef::set);){
            stream.transferTo(OutputStream.nullOutputStream());
        }
        return checksumsRef.get();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " (basedir=" + String.valueOf(this.basedir) + " mayLink=" + this.mayLink + " exclusiveAccess=" + this.exclusiveAccess + " cachePurge=" + this.cachePurge + ")";
    }
}

