/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.file;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class FileNodeConfig {
    public static final String NAME = "file";
    private final Path basedir;
    private final boolean mayLink;
    private final List<String> checksumAlgorithms;
    private final String keyResolver;
    private final boolean exclusiveAccess;
    private final boolean cachePurge;

    public static FileNodeConfig with(SessionConfig sessionConfig) {
        Objects.requireNonNull(sessionConfig, "config");
        Path basedir = sessionConfig.basedir().resolve("local");
        boolean mayLink = true;
        List<String> checksumAlgorithms = Arrays.asList("SHA-1", "SHA-512");
        String keyResolver = "simple";
        boolean exclusiveAccess = false;
        boolean cachePurge = false;
        if (sessionConfig.effectiveProperties().containsKey("mimir.file.basedir")) {
            basedir = FileUtils.canonicalPath(Path.of(sessionConfig.effectiveProperties().get("mimir.file.basedir"), new String[0]));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.file.mayLink")) {
            mayLink = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.file.mayLink"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.file.checksumAlgorithms")) {
            checksumAlgorithms = Arrays.stream(sessionConfig.effectiveProperties().get("mimir.file.checksumAlgorithms").split(",")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.file.keyResolver")) {
            keyResolver = sessionConfig.effectiveProperties().get("mimir.file.keyResolver");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.file.exclusiveAccess")) {
            exclusiveAccess = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.file.exclusiveAccess"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.file.cachePurge")) {
            cachePurge = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.file.cachePurge"));
        }
        return new FileNodeConfig(basedir, mayLink, checksumAlgorithms, keyResolver, exclusiveAccess, cachePurge);
    }

    public static FileNodeConfig of(Path basedir, boolean mayLink, List<String> checksumAlgorithms, String keyResolver, boolean exclusiveAccess, boolean cachePurge) {
        return new FileNodeConfig(FileUtils.canonicalPath(basedir), mayLink, checksumAlgorithms, keyResolver, exclusiveAccess, cachePurge);
    }

    private FileNodeConfig(Path basedir, boolean mayLink, List<String> checksumAlgorithms, String keyResolver, boolean exclusiveAccess, boolean cachePurge) {
        this.basedir = basedir;
        this.mayLink = mayLink;
        this.checksumAlgorithms = List.copyOf(checksumAlgorithms);
        this.keyResolver = keyResolver;
        this.exclusiveAccess = exclusiveAccess;
        this.cachePurge = cachePurge;
    }

    public Path basedir() {
        return this.basedir;
    }

    public boolean mayLink() {
        return this.mayLink;
    }

    public List<String> checksumAlgorithms() {
        return this.checksumAlgorithms;
    }

    public String keyResolver() {
        return this.keyResolver;
    }

    public boolean exclusiveAccess() {
        return this.exclusiveAccess;
    }

    public boolean cachePurge() {
        return this.cachePurge;
    }
}

