/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.jgroups;

import eu.maveniverse.maven.mimir.shared.impl.Executors;
import eu.maveniverse.maven.mimir.shared.impl.Utils;
import eu.maveniverse.maven.mimir.shared.impl.node.RemoteNodeSupport;
import eu.maveniverse.maven.mimir.shared.impl.publisher.PublisherRemoteEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.mimir.shared.publisher.Publisher;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.Response;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class JGroupsNode
extends RemoteNodeSupport<PublisherRemoteEntry>
implements Receiver,
RequestHandler {
    private static final String PUBLISHER_HANDLE = "handle";
    private static final String CMD_LOCATE = "locate";
    private static final String RSP_ERROR = "error";
    private final JChannel channel;
    private final MessageDispatcher messageDispatcher;
    private final Publisher publisher;
    private final AtomicReference<View> lastView;
    private final ExecutorService executor;

    public JGroupsNode(String clusterName, JChannel channel) throws Exception {
        super("jgroups", 500);
        this.channel = channel;
        this.messageDispatcher = new MessageDispatcher(channel);
        this.messageDispatcher.setAsynDispatching(true);
        this.messageDispatcher.setReceiver(this);
        this.publisher = null;
        this.lastView = new AtomicReference<Object>(null);
        this.executor = Executors.executorService();
        channel.connect(clusterName, null, 1500L);
    }

    public JGroupsNode(String clusterName, JChannel channel, Publisher publisher) throws Exception {
        super("jgroups", 500);
        this.channel = channel;
        this.messageDispatcher = new MessageDispatcher(channel, this);
        this.messageDispatcher.setAsynDispatching(true);
        this.messageDispatcher.setReceiver(this);
        this.publisher = publisher;
        this.lastView = new AtomicReference<Object>(null);
        this.executor = Executors.executorService();
        channel.connect(clusterName, null, 1500L);
    }

    @Override
    public Optional<PublisherRemoteEntry> locate(URI key) throws IOException {
        ArrayList<String> req = new ArrayList<String>();
        req.add(CMD_LOCATE);
        req.add(key.toASCIIString());
        try {
            RspList responses = this.messageDispatcher.castMessage(null, new ObjectMessage(null, req), RequestOptions.SYNC());
            for (Address responder : responses.keySet()) {
                Map data = (Map)((Rsp)responses.get(responder)).getValue();
                if (data != null && !data.isEmpty()) {
                    if (data.containsKey(PUBLISHER_HANDLE)) {
                        URI handle = URI.create(Objects.requireNonNull((String)data.remove(PUBLISHER_HANDLE), PUBLISHER_HANDLE));
                        return Optional.of(new PublisherRemoteEntry(Utils.splitMetadata(data), Utils.splitChecksums(data), handle));
                    }
                    throw new IOException((String)data.remove(RSP_ERROR));
                }
                this.logger.info("Ignoring null/empty response from {}", (Object)responder);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to locate", e);
        }
        return Optional.empty();
    }

    @Override
    public void viewAccepted(View view) {
        View prev = this.lastView.get();
        this.logger.info("Cluster {}: ", (Object)(prev == null ? "info" : "update"));
        this.logger.info("  Members: {}", (Object)view.getMembers());
        if (prev != null) {
            List<Address> leftMembers;
            List<Address> newMembers = View.newMembers(prev, view);
            if (!newMembers.isEmpty()) {
                this.logger.debug("  New members: {}", (Object)newMembers);
            }
            if (!(leftMembers = View.leftMembers(prev, view)).isEmpty()) {
                this.logger.debug("  Left members: {}", (Object)leftMembers);
            }
        }
        this.lastView.compareAndSet(prev, view);
    }

    @Override
    public Object handle(Message msg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handle(Message msg, Response response) {
        this.executor.submit(() -> {
            Thread.currentThread().setName("JVT");
            HashMap<String, String> responseMap = new HashMap<String, String>();
            boolean responseException = false;
            try {
                List req = (List)msg.getObject();
                if (req.size() == 2 && CMD_LOCATE.equals(req.get(0))) {
                    String keyString = (String)req.get(1);
                    URI key = URI.create(keyString);
                    Optional<Publisher.Handle> handle = this.publisher.createHandle(key);
                    if (handle.isPresent()) {
                        Publisher.Handle publisherHandle = handle.orElseThrow();
                        SystemEntry publishedEntry = publisherHandle.publishedEntry();
                        URI publishedHandle = publisherHandle.handle();
                        responseMap.putAll(Utils.mergeEntry(publishedEntry));
                        responseMap.put(PUBLISHER_HANDLE, publishedHandle.toASCIIString());
                        this.logger.info("OK: {} asked {}", (Object)msg.getSrc(), (Object)keyString);
                    } else {
                        this.logger.info("KO: {} asked {}", (Object)msg.getSrc(), (Object)keyString);
                    }
                } else {
                    responseMap.put(RSP_ERROR, "Unknown command");
                    responseException = true;
                    this.logger.info("UNKNOWN COMMAND: {}", (Object)req);
                }
                response.send(responseMap, responseException);
            }
            catch (IOException e) {
                responseMap.put(RSP_ERROR, e.getMessage());
                response.send(responseMap, true);
            }
        });
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " (distance=" + this.distance + " channel=" + String.valueOf(this.channel.getAddress()) + " clusterName=" + this.channel.getClusterName() + " publisher=" + String.valueOf(this.publisher) + ")";
    }

    @Override
    protected void doClose() throws IOException {
        if (this.publisher != null) {
            this.publisher.close();
        }
        this.messageDispatcher.close();
        this.channel.close();
    }
}

