/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.jgroups;

import eu.maveniverse.maven.mimir.node.jgroups.JGroupsNode;
import eu.maveniverse.maven.mimir.node.jgroups.JGroupsNodeConfig;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.node.RemoteNodeFactory;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import eu.maveniverse.maven.mimir.shared.publisher.PublisherFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jgroups.JChannel;

@Singleton
@Named(value="jgroups")
public class JGroupsNodeFactory
implements RemoteNodeFactory {
    private final SystemNode<?> systemNode;
    private final Map<String, PublisherFactory> publisherFactories;

    @Inject
    public JGroupsNodeFactory(SystemNode<?> systemNode, Map<String, PublisherFactory> publisherFactories) {
        this.systemNode = Objects.requireNonNull(systemNode, "systemNode");
        this.publisherFactories = Objects.requireNonNull(publisherFactories, "publisherFactories");
    }

    public Optional<JGroupsNode> createNode(SessionConfig sessionConfig) throws IOException {
        Objects.requireNonNull(sessionConfig, "config");
        try {
            JGroupsNodeConfig cfg = JGroupsNodeConfig.with(sessionConfig);
            if (!cfg.enabled()) {
                return Optional.empty();
            }
            if (cfg.publisherEnabled()) {
                PublisherFactory publisherFactory = this.publisherFactories.get(cfg.publisherTransport());
                if (publisherFactory == null) {
                    throw new IllegalStateException("No publisher found for transport " + cfg.publisherTransport());
                }
                return Optional.of(new JGroupsNode(cfg.jgroupsClusterName(), this.createChannel(sessionConfig, cfg), publisherFactory.createPublisher(sessionConfig, this.systemNode)));
            }
            return Optional.of(new JGroupsNode(cfg.jgroupsClusterName(), this.createChannel(sessionConfig, cfg)));
        }
        catch (Exception e) {
            throw new IOException("Failed to create JChannel", e);
        }
    }

    private JChannel createChannel(SessionConfig sessionConfig, JGroupsNodeConfig cfg) throws Exception {
        if (System.getProperty("jgroups.bind_addr") == null) {
            String hint = null;
            if (cfg.jgroupsInterface() != null) {
                hint = cfg.jgroupsInterface();
            } else if (sessionConfig.localHostHint().isPresent()) {
                hint = sessionConfig.localHostHint().orElseThrow();
            }
            if (hint != null) {
                System.setProperty("jgroups.bind_addr", hint);
            }
        }
        return new JChannel(cfg.jgroupsProps()).name(cfg.jgroupsNodeName()).setDiscardOwnMessages(true);
    }
}

