/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.minio;

import eu.maveniverse.maven.mimir.shared.impl.node.EntrySupport;
import eu.maveniverse.maven.mimir.shared.naming.Key;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.MinioClient;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public final class MinioEntry
extends EntrySupport
implements SystemEntry {
    private final MinioClient minioClient;
    private final Key key;

    MinioEntry(Map<String, String> metadata, Map<String, String> checksums, MinioClient minioClient, Key key) {
        super(metadata, checksums);
        this.minioClient = Objects.requireNonNull(minioClient, "minioClient");
        this.key = Objects.requireNonNull(key, "key");
    }

    @Override
    public InputStream inputStream() throws IOException {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.key.container())).object(this.key.name())).build());
        }
        catch (MinioException e) {
            this.logger.debug(e.httpTrace());
            throw new IOException("inputStream()", e);
        }
        catch (Exception e) {
            throw new IOException("inputStream()", e);
        }
    }

    @Override
    public void transferTo(Path file) throws IOException {
        Files.deleteIfExists(file);
        try (FileUtils.CollocatedTempFile f = FileUtils.newTempFile(file);){
            this.minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(this.key.container())).object(this.key.name())).filename(f.getPath().toString()).build());
            f.move();
        }
        catch (MinioException e) {
            this.logger.debug(e.httpTrace());
            throw new IOException("transferTo()", e);
        }
        catch (Exception e) {
            throw new IOException("transferTo()", e);
        }
    }
}

