/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.minio;

import eu.maveniverse.maven.mimir.node.minio.MinioEntry;
import eu.maveniverse.maven.mimir.node.minio.MinioNodeConfig;
import eu.maveniverse.maven.mimir.node.minio.Utils;
import eu.maveniverse.maven.mimir.shared.impl.checksum.ChecksumEnforcer;
import eu.maveniverse.maven.mimir.shared.impl.checksum.ChecksumInputStream;
import eu.maveniverse.maven.mimir.shared.impl.node.NodeSupport;
import eu.maveniverse.maven.mimir.shared.naming.Key;
import eu.maveniverse.maven.mimir.shared.node.Entry;
import eu.maveniverse.maven.mimir.shared.node.LocalEntry;
import eu.maveniverse.maven.mimir.shared.node.RemoteEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.Directive;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

public final class MinioNode
extends NodeSupport<MinioEntry>
implements SystemNode<MinioEntry> {
    private final MinioNodeConfig config;
    private final MinioClient minioClient;
    private final boolean exclusiveAccess;
    private final boolean cachePurge;
    private final Function<URI, Key> keyResolver;
    private final List<String> checksumAlgorithms;
    private final Map<String, ChecksumAlgorithmFactory> checksumFactories;

    public MinioNode(MinioNodeConfig config, MinioClient minioClient, boolean exclusiveAccess, boolean cachePurge, Function<URI, Key> keyResolver, List<String> checksumAlgorithms, Map<String, ChecksumAlgorithmFactory> checksumFactories) {
        super("minio");
        this.config = Objects.requireNonNull(config, "config");
        this.minioClient = Objects.requireNonNull(minioClient, "minioClient");
        this.exclusiveAccess = exclusiveAccess;
        this.cachePurge = cachePurge;
        this.keyResolver = Objects.requireNonNull(keyResolver, "keyResolver");
        this.checksumAlgorithms = Objects.requireNonNull(checksumAlgorithms, "checksumAlgorithms");
        this.checksumFactories = Objects.requireNonNull(checksumFactories, "checksumFactories");
    }

    @Override
    public List<String> checksumAlgorithms() {
        return this.checksumAlgorithms;
    }

    @Override
    public Map<String, ChecksumAlgorithmFactory> checksumFactories() {
        return this.checksumFactories;
    }

    @Override
    public Optional<MinioEntry> locate(URI key) throws IOException {
        this.checkClosed();
        Key localKey = this.keyResolver.apply(key);
        try {
            StatObjectResponse stat = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).build());
            Map<String, String> userMetadata = Utils.popMap(stat.userMetadata());
            return Optional.of(new MinioEntry(eu.maveniverse.maven.mimir.shared.impl.Utils.splitMetadata(userMetadata), eu.maveniverse.maven.mimir.shared.impl.Utils.splitChecksums(userMetadata), this.minioClient, localKey));
        }
        catch (ErrorResponseException e) {
            return Optional.empty();
        }
        catch (MinioException e) {
            this.logger.debug(e.httpTrace());
            throw new IOException("inputStream()", e);
        }
        catch (Exception e) {
            throw new IOException("inputStream()", e);
        }
    }

    @Override
    public boolean exclusiveAccess() {
        return this.exclusiveAccess;
    }

    @Override
    public MinioEntry store(URI key, Entry entry) throws IOException {
        Key localKey;
        block25: {
            this.checkClosed();
            localKey = this.keyResolver.apply(key);
            long contentLength = entry.getContentLength();
            if (entry instanceof RemoteEntry) {
                RemoteEntry remoteEntry = (RemoteEntry)entry;
                remoteEntry.handleContent(inputStream2 -> {
                    try {
                        ChecksumEnforcer checksumEnforcer;
                        try {
                            checksumEnforcer = new ChecksumEnforcer(entry.checksums());
                            try (ChecksumInputStream enforced = new ChecksumInputStream(inputStream2, this.checksumAlgorithms().stream().map(a -> new AbstractMap.SimpleEntry<String, ChecksumAlgorithm>((String)a, this.checksumFactories.get(a).getAlgorithm())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), checksumEnforcer);){
                                this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).stream(enforced, contentLength, -1L).build());
                            }
                        }
                        catch (ChecksumEnforcer.ChecksumEnforcerException e) {
                            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).build());
                            throw e;
                        }
                        this.minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).userMetadata(Utils.pushMap(eu.maveniverse.maven.mimir.shared.impl.Utils.mergeEntry(entry.metadata(), checksumEnforcer.getChecksums())))).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(localKey.container())).object(localKey.name())).build()).build());
                    }
                    catch (MinioException e) {
                        this.logger.debug(e.httpTrace());
                        throw new IOException("inputStream()", e);
                    }
                    catch (Exception e) {
                        throw new IOException("inputStream()", e);
                    }
                });
            } else {
                if (entry instanceof SystemEntry) {
                    SystemEntry systemEntry = (SystemEntry)entry;
                    try (InputStream inputStream3 = systemEntry.inputStream();){
                        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).userMetadata(Utils.pushMap(eu.maveniverse.maven.mimir.shared.impl.Utils.mergeEntry(entry)))).stream(inputStream3, contentLength, -1L).build());
                        break block25;
                    }
                    catch (MinioException e) {
                        this.logger.debug(e.httpTrace());
                        throw new IOException("inputStream()", e);
                    }
                    catch (Exception e) {
                        throw new IOException("inputStream()", e);
                    }
                }
                if (entry instanceof LocalEntry) {
                    LocalEntry localEntry = (LocalEntry)entry;
                    Path tempFile = Files.createTempFile(localKey.container(), "minio", new FileAttribute[0]);
                    localEntry.transferTo(tempFile);
                    try (InputStream inputStream4 = Files.newInputStream(tempFile, new OpenOption[0]);){
                        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).userMetadata(Utils.pushMap(eu.maveniverse.maven.mimir.shared.impl.Utils.mergeEntry(entry)))).stream(inputStream4, contentLength, -1L).build());
                        break block25;
                    }
                    catch (MinioException e) {
                        this.logger.debug(e.httpTrace());
                        throw new IOException("inputStream()", e);
                    }
                    catch (Exception e) {
                        throw new IOException("inputStream()", e);
                    }
                    finally {
                        Files.deleteIfExists(tempFile);
                    }
                }
                throw new UnsupportedOperationException("Unsupported entry type: " + String.valueOf(entry.getClass()));
            }
        }
        return new MinioEntry(entry.metadata(), entry.checksums(), this.minioClient, localKey);
    }

    @Override
    public MinioEntry store(URI key, Path file, Map<String, String> md, Map<String, String> checksums) throws IOException {
        this.checkClosed();
        Key localKey = this.keyResolver.apply(key);
        long contentLength = Files.size(file);
        HashMap<String, String> metadata = new HashMap<String, String>(md);
        Entry.setContentLength(metadata, contentLength);
        Entry.setContentLastModified(metadata, Files.getLastModifiedTime(file, new LinkOption[0]).toInstant());
        try {
            ChecksumEnforcer checksumEnforcer;
            try {
                checksumEnforcer = new ChecksumEnforcer(checksums);
                try (ChecksumInputStream enforced = new ChecksumInputStream(Files.newInputStream(file, new OpenOption[0]), this.checksumAlgorithms().stream().map(a -> new AbstractMap.SimpleEntry<String, ChecksumAlgorithm>((String)a, this.checksumFactories.get(a).getAlgorithm())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), checksumEnforcer);){
                    this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).stream(enforced, contentLength, -1L).build());
                }
            }
            catch (ChecksumEnforcer.ChecksumEnforcerException e) {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).build());
                throw e;
            }
            this.minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(localKey.container())).object(localKey.name())).metadataDirective(Directive.REPLACE).userMetadata(Utils.pushMap(eu.maveniverse.maven.mimir.shared.impl.Utils.mergeEntry(metadata, checksumEnforcer.getChecksums())))).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(localKey.container())).object(localKey.name())).build()).build());
            return new MinioEntry(metadata, checksumEnforcer.getChecksums(), this.minioClient, localKey);
        }
        catch (MinioException e) {
            this.logger.debug(e.httpTrace());
            throw new IOException("inputStream()", e);
        }
        catch (Exception e) {
            throw new IOException("inputStream()", e);
        }
    }

    @Override
    protected void doClose() throws IOException {
        if (this.exclusiveAccess && this.cachePurge) {
            this.purgeCaches();
        }
        try {
            this.minioClient.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void purgeCaches() {
        this.logger.info("Purging caches...");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.config.endpoint() + ")";
    }
}

