/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.minio;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MinioNodeConfig {
    public static final String NAME = "minio";
    private final String endpoint;
    private final String accessKey;
    private final String secretKey;
    private final List<String> checksumAlgorithms;
    private final String keyResolver;
    private final boolean exclusiveAccess;
    private final boolean cachePurge;

    public static MinioNodeConfig with(SessionConfig sessionConfig) throws IOException {
        Objects.requireNonNull(sessionConfig, "config");
        String endpoint = "http://127.0.0.1:9000";
        String accessKey = "minioadmin";
        String secretKey = "minioadmin";
        List<String> checksumAlgorithms = Arrays.asList("SHA-1", "SHA-512");
        String keyResolver = "simple";
        boolean exclusiveAccess = false;
        boolean cachePurge = false;
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.endpoint")) {
            endpoint = sessionConfig.effectiveProperties().get("mimir.minio.endpoint");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.accessKey")) {
            accessKey = sessionConfig.effectiveProperties().get("mimir.minio.accessKey");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.secretKey")) {
            secretKey = sessionConfig.effectiveProperties().get("mimir.minio.secretKey");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.checksumAlgorithms")) {
            checksumAlgorithms = Arrays.stream(sessionConfig.effectiveProperties().get("mimir.minio.checksumAlgorithms").split(",")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.keyResolver")) {
            keyResolver = sessionConfig.effectiveProperties().get("mimir.minio.keyResolver");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.exclusiveAccess")) {
            exclusiveAccess = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.minio.exclusiveAccess"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.minio.cachePurge")) {
            cachePurge = Boolean.parseBoolean(sessionConfig.effectiveProperties().get("mimir.minio.cachePurge"));
        }
        return new MinioNodeConfig(endpoint, accessKey, secretKey, checksumAlgorithms, keyResolver, exclusiveAccess, cachePurge);
    }

    private MinioNodeConfig(String endpoint, String accessKey, String secretKey, List<String> checksumAlgorithms, String keyResolver, boolean exclusiveAccess, boolean cachePurge) {
        this.endpoint = endpoint;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.checksumAlgorithms = checksumAlgorithms;
        this.keyResolver = keyResolver;
        this.exclusiveAccess = exclusiveAccess;
        this.cachePurge = cachePurge;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String accessKey() {
        return this.accessKey;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public List<String> checksumAlgorithms() {
        return this.checksumAlgorithms;
    }

    public String keyResolver() {
        return this.keyResolver;
    }

    public boolean exclusiveAccess() {
        return this.exclusiveAccess;
    }

    public boolean cachePurge() {
        return this.cachePurge;
    }
}

