/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.minio;

import eu.maveniverse.maven.mimir.node.minio.MinioNode;
import eu.maveniverse.maven.mimir.node.minio.MinioNodeConfig;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.naming.KeyResolver;
import eu.maveniverse.maven.mimir.shared.naming.KeyResolverFactory;
import eu.maveniverse.maven.mimir.shared.node.SystemNodeFactory;
import io.minio.MinioClient;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

@Singleton
@Named(value="minio")
public class MinioNodeFactory
implements SystemNodeFactory {
    private final Map<String, KeyResolverFactory> keyResolverFactories;
    private final Map<String, ChecksumAlgorithmFactory> checksumFactories;

    @Inject
    public MinioNodeFactory(Map<String, KeyResolverFactory> keyResolverFactories, Map<String, ChecksumAlgorithmFactory> checksumFactories) {
        this.keyResolverFactories = Objects.requireNonNull(keyResolverFactories, "keyResolverFactories");
        this.checksumFactories = Objects.requireNonNull(checksumFactories, "checksumFactories");
    }

    @Override
    public MinioNode createNode(SessionConfig sessionConfig) throws IOException {
        MinioNodeConfig minioNodeConfig = MinioNodeConfig.with(sessionConfig);
        KeyResolverFactory keyResolverFactory = this.keyResolverFactories.get(minioNodeConfig.keyResolver());
        if (keyResolverFactory == null) {
            throw new IllegalArgumentException("Unknown keyResolver: " + minioNodeConfig.keyResolver());
        }
        KeyResolver keyResolver = Objects.requireNonNull(keyResolverFactory.createKeyResolver(sessionConfig), "keyResolver");
        for (String alg : minioNodeConfig.checksumAlgorithms()) {
            ChecksumAlgorithmFactory checksumAlgorithmFactory = this.checksumFactories.get(alg);
            if (checksumAlgorithmFactory != null) continue;
            throw new IllegalArgumentException("Unknown checksumAlgorithmFactory: " + alg);
        }
        MinioClient minioClient = this.createMinioClient(minioNodeConfig);
        return new MinioNode(minioNodeConfig, minioClient, minioNodeConfig.exclusiveAccess(), minioNodeConfig.cachePurge(), keyResolver, minioNodeConfig.checksumAlgorithms(), this.checksumFactories);
    }

    private MinioClient createMinioClient(MinioNodeConfig minioNodeConfig) {
        return MinioClient.builder().endpoint(minioNodeConfig.endpoint()).credentials(minioNodeConfig.accessKey(), minioNodeConfig.secretKey()).build();
    }
}

