/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.checksum;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class ChecksumEnforcer
implements Consumer<Map<String, String>> {
    private final Map<String, String> expectedChecksums;
    private final AtomicReference<Map<String, String>> checksums;

    public ChecksumEnforcer(Map<String, String> expectedChecksums) {
        this.expectedChecksums = Map.copyOf(Objects.requireNonNull(expectedChecksums, "expectedChecksums"));
        this.checksums = new AtomicReference();
    }

    @Override
    public void accept(Map<String, String> checksums) {
        this.checksums.set(Map.copyOf(Objects.requireNonNull(checksums, "checksums")));
        int matches = 0;
        for (Map.Entry<String, String> expectedEntry : this.expectedChecksums.entrySet()) {
            String checksum = checksums.get(expectedEntry.getKey());
            if (checksum == null) continue;
            if (checksum.equals(expectedEntry.getValue())) {
                ++matches;
                continue;
            }
            throw new UncheckedIOException(new ChecksumEnforcerException(String.format("Checksum %s does not match expected value %s", checksum, expectedEntry.getValue()), this.expectedChecksums, checksums));
        }
        if (matches == 0) {
            throw new UncheckedIOException(new ChecksumEnforcerException(String.format("No checksum algorithm intersection exists: expected %s vs calculated %s", this.expectedChecksums.keySet(), checksums.keySet()), this.expectedChecksums, checksums));
        }
    }

    public Map<String, String> getExpectedChecksums() {
        return this.expectedChecksums;
    }

    public Map<String, String> getChecksums() {
        return this.checksums.get();
    }

    public static class ChecksumEnforcerException
    extends IOException {
        private final Map<String, String> expected;
        private final Map<String, String> received;

        public ChecksumEnforcerException(String message, Map<String, String> expected, Map<String, String> received) {
            super(message);
            this.expected = Objects.requireNonNull(expected);
            this.received = Objects.requireNonNull(received);
        }

        public Map<String, String> getExpected() {
            return this.expected;
        }

        public Map<String, String> getReceived() {
            return this.received;
        }
    }
}

