/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.publisher;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import eu.maveniverse.maven.mimir.shared.impl.Executors;
import eu.maveniverse.maven.mimir.shared.impl.publisher.PublisherConfig;
import eu.maveniverse.maven.mimir.shared.impl.publisher.PublisherSupport;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class HttpServerPublisher
extends PublisherSupport {
    private final HttpServer httpServer;

    public HttpServerPublisher(SystemNode<?> systemNode, PublisherConfig publisherConfig) throws IOException {
        super(systemNode, publisherConfig);
        this.httpServer = HttpServer.create(new InetSocketAddress(publisherConfig.hostPort()), 0);
        this.httpServer.setExecutor(Executors.executorService());
        this.httpServer.createContext("/txid", new TxHandler(this::publishedEntry));
        this.logger.info("HTTP publisher starting at {} -> {}:{}", this.httpServer.getAddress(), publisherConfig.hostAddress(), this.httpServer.getAddress().getPort());
        this.httpServer.start();
    }

    @Override
    protected URI createHandle(String token) {
        return URI.create("http://" + this.publisherConfig.hostAddress() + ":" + this.httpServer.getAddress().getPort() + "/txid/" + token);
    }

    @Override
    protected void doClose() {
        this.logger.info("HTTP publisher stopping at {}", (Object)this.httpServer.getAddress());
        this.httpServer.stop(0);
    }

    public String toString() {
        return "HTTP(" + this.publisherConfig.hostAddress() + ":" + this.httpServer.getAddress().getPort() + ")";
    }

    private static class TxHandler
    extends ComponentSupport
    implements HttpHandler {
        private final Function<String, Optional<SystemEntry>> entrySupplier;
        private final DateTimeFormatter rfc7231 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));

        public TxHandler(Function<String, Optional<SystemEntry>> entrySupplier) {
            this.entrySupplier = Objects.requireNonNull(entrySupplier, "entrySupplier");
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            block16: {
                try {
                    String ctxPath = exchange.getHttpContext().getPath();
                    String path = exchange.getRequestURI().getPath();
                    if ("GET".equals(exchange.getRequestMethod()) && path.length() > ctxPath.length()) {
                        String token = exchange.getRequestURI().getPath().substring(ctxPath.length() + 1);
                        Optional<SystemEntry> entry = this.entrySupplier.apply(token);
                        if (entry.isPresent()) {
                            SystemEntry systemEntry = entry.orElseThrow();
                            Headers headers = exchange.getResponseHeaders();
                            headers.add("Last-Modified", this.rfc7231.format(systemEntry.getContentLastModified()));
                            headers.add("Content-Type", "application/octet-stream");
                            this.logger.debug("HIT {} to {}", (Object)token, (Object)exchange.getRemoteAddress());
                            exchange.sendResponseHeaders(200, systemEntry.getContentLength());
                            try (OutputStream os = exchange.getResponseBody();
                                 InputStream is = systemEntry.inputStream();){
                                is.transferTo(os);
                                break block16;
                            }
                        }
                        this.logger.info("MISS {} to {}", (Object)token, (Object)exchange.getRemoteAddress());
                        exchange.sendResponseHeaders(404, -1L);
                        break block16;
                    }
                    exchange.sendResponseHeaders(405, -1L);
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), e);
                    throw e;
                }
            }
        }
    }
}

